/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.AccessTokenResponseContext;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class IDTokenInAccessTokenUpdateStrategy
implements BiConsumer<ProfileRequestContext, JWT> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(IDTokenInAccessTokenUpdateStrategy.class);
    @Nonnull
    private final Function<ProfileRequestContext, AccessTokenResponseContext> tokenResponseContextLookupStrategy;

    public IDTokenInAccessTokenUpdateStrategy(@ParameterName(name="accessTokenContextLookupStrategy") Function<ProfileRequestContext, AccessTokenResponseContext> strategy) {
        this.tokenResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"accessTokenContextLookupStrategy can not be null");
    }

    public IDTokenInAccessTokenUpdateStrategy() {
        this.tokenResponseContextLookupStrategy = new ChildContextLookup(AccessTokenResponseContext.class, true).compose((Function)new InboundMessageContextLookup());
    }

    @Override
    public void accept(ProfileRequestContext profileRequestContext, JWT idToken) {
        OIDCTokenResponse tokenReponse;
        AccessTokenResponseContext context = this.tokenResponseContextLookupStrategy.apply(profileRequestContext);
        OIDCTokenResponse oIDCTokenResponse = tokenReponse = context != null ? context.getTokenResponse() : null;
        if (context != null && tokenReponse != null) {
            try {
                JSONObject jsonToken = tokenReponse.toJSONObject();
                jsonToken.put((Object)"id_token", (Object)idToken.serialize());
                context.setTokenResponse(OIDCTokenResponse.parse((JSONObject)jsonToken));
            }
            catch (ParseException e) {
                this.log.warn("Unable to set id_token back onto access token response", (Throwable)e);
            }
        } else {
            this.log.warn("Unable to set id_token back onto access token response context");
        }
    }
}

