/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.UserInfoResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate.AbstractUserInfoTokenResponseLookupStrategy;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

@ThreadSafe
public class EncryptedUserInfoJWTLookupStrategy
extends AbstractUserInfoTokenResponseLookupStrategy
implements Function<ProfileRequestContext, JWT> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EncryptedUserInfoJWTLookupStrategy.class);

    public EncryptedUserInfoJWTLookupStrategy(@ParameterName(name="userInfoResponseContextLookupStrategy") Function<ProfileRequestContext, UserInfoResponseContext> strategy) {
        super(strategy);
    }

    public EncryptedUserInfoJWTLookupStrategy() {
    }

    @Override
    @Nullable
    public JWT apply(@Nullable ProfileRequestContext prc) {
        UserInfoSuccessResponse userInfo;
        UserInfoResponseContext userInfoContext = this.getUserInfoResponseContextLookupStrategy().apply(prc);
        UserInfoSuccessResponse userInfoSuccessResponse = userInfo = userInfoContext != null ? userInfoContext.getUserInfo() : null;
        if (userInfo == null) {
            return null;
        }
        if (userInfo.getUserInfoJWT() == null) {
            this.log.trace("EncryptedUserInfoToken Lookup: UserInfo response JWT is null, nothing to return");
            return null;
        }
        JWT token = userInfo.getUserInfoJWT();
        if (token instanceof EncryptedJWT) {
            this.log.trace("EncryptedUserInfoToken Lookup: UserInfo response JWT is encrypted using algorithm '{}'", (Object)token.getHeader().getAlgorithm());
            return token;
        }
        if (token instanceof SignedJWT) {
            this.log.trace("EncryptedUserInfoToken Lookup:  UserInfo response JWT is signed and not encrypted, nothing to return");
            return null;
        }
        this.log.trace("EncryptedUserInfoToken Lookup:  UserInfo response JWT is neither signed nor encrypted, nothing to return");
        return null;
    }
}

