/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.AccessTokenResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate.AbstractTokenResponseLookupStrategy;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

@ThreadSafe
public class EncryptedIDTokenLookupStrategy
extends AbstractTokenResponseLookupStrategy
implements Function<ProfileRequestContext, JWT> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EncryptedIDTokenLookupStrategy.class);

    public EncryptedIDTokenLookupStrategy() {
    }

    public EncryptedIDTokenLookupStrategy(@ParameterName(name="accessTokenContextLookupStrategy") @Nonnull Function<ProfileRequestContext, AccessTokenResponseContext> strategy) {
        super(strategy);
    }

    @Override
    @Nullable
    public JWT apply(@Nullable ProfileRequestContext prc) {
        OIDCTokenResponse tokenResponse;
        AccessTokenResponseContext tokenContext = this.getTokenResponseContextLookupStrategy().apply(prc);
        OIDCTokenResponse oIDCTokenResponse = tokenResponse = tokenContext != null ? tokenContext.getTokenResponse() : null;
        if (tokenResponse == null) {
            return null;
        }
        JWT token = tokenResponse.getOIDCTokens().getIDToken();
        if (token instanceof EncryptedJWT) {
            this.log.trace("EncryptedIDToken Lookup: ID Token is encrypted using algorithm '{}'", (Object)token.getHeader().getAlgorithm());
            return token;
        }
        if (token instanceof SignedJWT) {
            this.log.trace("EncryptedIDToken Lookup: ID Token is signed and not encrypted, nothing to return");
            return null;
        }
        this.log.trace("EncryptedIDToken Lookup: ID Token is neither signed nor encrypted, nothing to return");
        return null;
    }
}

