/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class AuthenticationRequestTimeLookupFunction
implements Function<ProfileRequestContext, Instant> {
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationRequest> authenticationRequestLookupStrategy = prc -> {
        Object outboundMessage = prc.ensureOutboundMessageContext().getMessage();
        if (outboundMessage instanceof OIDCAuthenticationRequest) {
            OIDCAuthenticationRequest authnRequest = (OIDCAuthenticationRequest)outboundMessage;
            return authnRequest;
        }
        return null;
    };

    public void setAuthenticationRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationRequest> strategy) {
        this.authenticationRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthenticationRequestLookupStrategy lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public Instant apply(@Nullable ProfileRequestContext input) {
        if (input == null) {
            return null;
        }
        OIDCAuthenticationRequest authnRequest = this.authenticationRequestLookupStrategy.apply(input);
        return authnRequest == null ? null : authnRequest.getAuthnRequestTime();
    }
}

