/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.config.navigate;

import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.config.OIDCAuthenticationRelyingPartyProfileConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.navigate.AbstractRelyingPartyLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;

public class RedirectUriLookupFunction
extends AbstractRelyingPartyLookupFunction<URI> {
    @Nullable
    public URI apply(@Nullable ProfileRequestContext input) {
        ProfileConfiguration pc;
        RelyingPartyContext rpc = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null && (pc = rpc.getProfileConfig()) instanceof OIDCAuthenticationRelyingPartyProfileConfiguration) {
            OIDCAuthenticationRelyingPartyProfileConfiguration config = (OIDCAuthenticationRelyingPartyProfileConfiguration)pc;
            try {
                String uriString = config.getRedirectUriOverride(input);
                return uriString != null ? new URI(uriString) : null;
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }
}

