/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.config.navigate;

import java.time.Duration;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.config.OIDCAuthenticationProfileConfiguration;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.navigate.AbstractRelyingPartyLookupFunction;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;

public class MaxAgeLookupFunction
extends AbstractRelyingPartyLookupFunction<Duration> {
    @Nonnull
    private final Duration maxAgeDefault;
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationRequest> authenticationRequestLookupStrategy;

    public MaxAgeLookupFunction(@ParameterName(name="maxAgeDefault") @Nonnull Duration defaultAge) {
        this.maxAgeDefault = (Duration)Constraint.isNotNull((Object)defaultAge, (String)"Max Age default can not be null");
        this.authenticationRequestLookupStrategy = prc -> {
            Object patt2594$temp;
            MessageContext msgCtx = prc.getOutboundMessageContext();
            if (msgCtx != null && msgCtx.getMessage() != null && (patt2594$temp = msgCtx.getMessage()) instanceof OIDCAuthenticationRequest) {
                OIDCAuthenticationRequest request = (OIDCAuthenticationRequest)patt2594$temp;
                return request;
            }
            return null;
        };
    }

    public void setAuthenticationRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationRequest> strategy) {
        this.authenticationRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthenticationRequestLookupStrategy can not be null");
    }

    @Nonnull
    public Duration apply(@Nullable ProfileRequestContext input) {
        ProfileConfiguration pc;
        Duration authnRequestMaxAge;
        OIDCAuthenticationRequest authnRequest = this.authenticationRequestLookupStrategy.apply(input);
        Duration duration = authnRequestMaxAge = authnRequest != null ? authnRequest.getMaxAge() : null;
        if (authnRequestMaxAge != null) {
            return authnRequestMaxAge;
        }
        RelyingPartyContext rpc = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null && (pc = rpc.getProfileConfig()) instanceof OIDCAuthenticationProfileConfiguration) {
            OIDCAuthenticationProfileConfiguration config = (OIDCAuthenticationProfileConfiguration)pc;
            Duration maxAge = config.getMaxAuthenticationAge(input);
            if (maxAge == null) {
                return this.maxAgeDefault;
            }
            return maxAge;
        }
        return this.maxAgeDefault;
    }
}

