/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.config.navigate;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.profile.config.OIDCIDTokenProducingProfileConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class ExtraAudiencesLookupStrategy
implements BiFunction<ProfileRequestContext, JWTClaimsSet, Set<String>> {
    @Nonnull
    private final Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;

    public ExtraAudiencesLookupStrategy(@ParameterName(name="relyingPartyContextLookupStrategy") @Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    @Override
    public Set<String> apply(ProfileRequestContext prc, JWTClaimsSet claims) {
        ProfileConfiguration pc;
        RelyingPartyContext rpc = this.relyingPartyContextLookupStrategy.apply(prc);
        if (rpc != null && (pc = rpc.getProfileConfig()) instanceof OIDCIDTokenProducingProfileConfiguration) {
            OIDCIDTokenProducingProfileConfiguration config = (OIDCIDTokenProducingProfileConfiguration)pc;
            return config.getAdditionalAudiencesForIdToken(prc);
        }
        return Collections.emptySet();
    }
}

