/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.sdk.impl;

import com.duosecurity.Client;
import com.duosecurity.exception.DuoException;
import com.duosecurity.model.HealthCheckResponse;
import com.duosecurity.model.Token;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.duo.AbstractDuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.model.DuoHealthCheck;
import net.shibboleth.idp.plugin.authn.duo.model.DuoHealthCheckResponse;
import net.shibboleth.oidc.security.JWSAssemblyUtils;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafe
@Immutable
public final class DuoSDKClientAdaptor
extends AbstractDuoOIDCClient {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DuoSDKClientAdaptor.class);
    @Nonnull
    private final Client client;
    @Nonnull
    private final Function<HealthCheckResponse, DuoHealthCheck> healthCheckResponseConverter;
    @Nonnull
    private final BiFunction<Token, DuoOIDCIntegration, JWT> tokenResponseConverter;
    @Nonnull
    private final DuoOIDCIntegration duoIntegration;

    DuoSDKClientAdaptor(@Nonnull DuoOIDCIntegration integration, @Nullable List<String> caCerts) throws DuoClientException {
        this.duoIntegration = (DuoOIDCIntegration)Constraint.isNotNull((Object)integration, (String)"Duo SDK Client requires a non-null Duo Integration");
        this.healthCheckResponseConverter = new DefaultHealthCheckResponseConverter();
        this.tokenResponseConverter = new DefaultTokenResponseConverter();
        try {
            if (caCerts == null) {
                Client newClient = new Client.Builder(integration.getClientId(), integration.getSecretKey(), integration.getAPIHost(), integration.getRedirectURI()).setUseDuoCodeAttribute(false).build();
                assert (newClient != null);
                this.client = newClient;
            } else {
                Client newClient = new Client.Builder(integration.getClientId(), integration.getSecretKey(), integration.getAPIHost(), integration.getRedirectURI()).setCACerts(caCerts.toArray(new String[caCerts.size()])).setUseDuoCodeAttribute(false).build();
                assert (newClient != null);
                this.client = newClient;
            }
        }
        catch (DuoException e) {
            throw new DuoClientException((Throwable)e);
        }
    }

    DuoSDKClientAdaptor(@Nonnull DuoOIDCIntegration integration, @Nullable List<String> caCerts, @Nonnull @NotEmpty String proxyHost, @Nonnull Integer proxyPort) throws DuoClientException {
        this.duoIntegration = (DuoOIDCIntegration)Constraint.isNotNull((Object)integration, (String)"Duo SDK Client requires a non-null Duo Integration");
        this.healthCheckResponseConverter = new DefaultHealthCheckResponseConverter();
        this.tokenResponseConverter = new DefaultTokenResponseConverter();
        try {
            if (caCerts == null) {
                Client newClient = new Client.Builder(integration.getClientId(), integration.getSecretKey(), integration.getAPIHost(), proxyPort, proxyHost, integration.getRedirectURI()).setUseDuoCodeAttribute(false).build();
                assert (newClient != null);
                this.client = newClient;
            } else {
                Client newClient = new Client.Builder(integration.getClientId(), integration.getSecretKey(), integration.getAPIHost(), proxyPort, proxyHost, integration.getRedirectURI()).setCACerts(caCerts.toArray(new String[caCerts.size()])).setUseDuoCodeAttribute(false).build();
                assert (newClient != null);
                this.client = newClient;
            }
        }
        catch (DuoException e) {
            throw new DuoClientException((Throwable)e);
        }
    }

    @Nonnull
    public DuoHealthCheck healthCheck() throws DuoClientException {
        try {
            HealthCheckResponse response = this.client.healthCheck();
            if (response == null) {
                throw new DuoClientException("Duo health check response was null");
            }
            DuoHealthCheck check = this.healthCheckResponseConverter.apply(response);
            if (check == null) {
                throw new DuoClientException("Converted Duo health check response was null");
            }
            return check;
        }
        catch (DuoException e) {
            throw new DuoClientException((Throwable)e);
        }
    }

    @Nonnull
    public String createAuthUrl(@Nonnull @NotEmpty String username, @Nonnull @NotEmpty String state, @Nullable String nonce, @Nullable String redirectURIOverride) throws DuoClientException {
        Constraint.isNotEmpty((String)username, (String)"Username can not be null or empty");
        Constraint.isNotEmpty((String)state, (String)"State can not be null or empty");
        try {
            String authUrl = this.client.createAuthUrl(username, state);
            assert (authUrl != null);
            return authUrl;
        }
        catch (DuoException e) {
            throw new DuoClientException((Throwable)e);
        }
    }

    @Nonnull
    public JWT exchangeAuthorizationCodeFor2FAResult(@Nonnull String code, @Nonnull String username, @Nullable String redirectURIOverride) throws DuoClientException {
        Constraint.isNotEmpty((String)code, (String)"Auth_code can not be null");
        try {
            Token token = this.client.exchangeAuthorizationCodeFor2FAResult(code, username);
            if (token == null) {
                throw new DuoClientException("Duo token was null");
            }
            JWT tokenAsJWT = this.tokenResponseConverter.apply(token, this.duoIntegration);
            if (tokenAsJWT == null) {
                throw new DuoClientException("Duo token could not be converted to a JWT");
            }
            return tokenAsJWT;
        }
        catch (DuoException e) {
            throw new DuoClientException((Throwable)e);
        }
    }

    public boolean isSupportsNonce() {
        return false;
    }

    @ThreadSafe
    private class DefaultHealthCheckResponseConverter
    implements Function<HealthCheckResponse, DuoHealthCheck> {
        private DefaultHealthCheckResponseConverter() {
        }

        @Override
        public DuoHealthCheck apply(@Nullable HealthCheckResponse response) {
            assert (response != null);
            Integer timestamp = response.getResponse().getTimestamp();
            assert (timestamp != null);
            return DuoHealthCheck.builder().withStatus(response.getStat()).withCode(response.getCode()).withMessage(response.getMessage()).withMessageDetail(response.getMessage_detail()).withResponse(new DuoHealthCheckResponse(timestamp)).withTimestamp(response.getTimestamp()).build();
        }
    }

    @ThreadSafe
    private final class DefaultTokenResponseConverter
    implements BiFunction<Token, DuoOIDCIntegration, JWT> {
        @Nonnull
        private final ObjectMapper objectMapper = new ObjectMapper();

        private DefaultTokenResponseConverter() {
        }

        @Override
        @Nullable
        public JWT apply(@Nullable Token t, @Nullable DuoOIDCIntegration integ) {
            if (integ == null) {
                return null;
            }
            try {
                String duoTokenAsJson = this.objectMapper.writeValueAsString((Object)t);
                JWTClaimsSet claims = JWTClaimsSet.parse((String)duoTokenAsJson);
                assert (claims != null);
                JWSAlgorithm algo = JWSAlgorithm.HS512;
                assert (algo != null);
                return JWSAssemblyUtils.assembleMacJws((JWSAlgorithm)algo, (JWTClaimsSet)claims, (byte[])JWSAssemblyUtils.getSecretBytes((String)integ.getSecretKey()));
            }
            catch (JsonProcessingException | JOSEException | ParseException | EncodingException e) {
                DuoSDKClientAdaptor.this.log.error("Could not convert Duo Token to a Nimbus JWT Token", e);
                return null;
            }
        }
    }
}

