/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo;

import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hc.core5.net.URIBuilder;

@ThreadSafe
public final class URISupport {
    private URISupport() {
    }

    @Nonnull
    public static final URI buildURIIgnoreDefaultPorts(@Nonnull String scheme, @Nonnull String host, int port, @Nonnull String path) throws URISyntaxException {
        int usedPort = port;
        if ("http".equalsIgnoreCase(scheme)) {
            if (port == 80) {
                usedPort = -1;
            }
        } else if ("https".equalsIgnoreCase(scheme) && port == 443) {
            usedPort = -1;
        }
        return new URIBuilder().setScheme(scheme).setHost(host).setPort(usedPort).setPath(path).build();
    }

    @Nonnull
    public static String buildOrigin(@Nonnull URI uri) throws URISyntaxException {
        if (uri.getPort() == -1) {
            return new URI(String.format("%s://%s", uri.getScheme(), uri.getHost())).toString();
        }
        return new URI(String.format("%s://%s:%s", uri.getScheme(), uri.getHost(), uri.getPort())).toString();
    }
}

