/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo;

import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultPasswordlessCondition
extends AbstractInitializableComponent
implements Predicate<ProfileRequestContext> {
    @Nonnull
    @NonnullElements
    private Set<String> allowedFactors = CollectionSupport.emptySet();

    public void setAllowedFactors(@Nonnull @NonnullElements Collection<String> factors) {
        this.checkSetterPreconditions();
        this.allowedFactors = CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(factors));
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        AuthenticationContext authenticationContext;
        this.checkComponentActive();
        AuthenticationContext authenticationContext2 = authenticationContext = input != null ? (AuthenticationContext)input.getSubcontext(AuthenticationContext.class) : null;
        if (authenticationContext == null) {
            return false;
        }
        DuoOIDCAuthenticationContext duoContext = (DuoOIDCAuthenticationContext)authenticationContext.getSubcontext(DuoOIDCAuthenticationContext.class);
        if (duoContext == null || duoContext.getFactorUsed() == null) {
            return false;
        }
        return this.allowedFactors.contains(duoContext.getFactorUsed());
    }
}

