/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractDuoAuthenticationAction
extends AbstractAuthenticationAction {
    @Nonnull
    @NotEmpty
    private final Logger log = LoggerFactory.getLogger(AbstractDuoAuthenticationAction.class);
    @Nonnull
    private Function<ProfileRequestContext, DuoOIDCAuthenticationContext> duoContextLookupStrategy = new ChildContextLookup(DuoOIDCAuthenticationContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));
    @NonnullBeforeExec
    private DuoOIDCAuthenticationContext duoContext;

    protected AbstractDuoAuthenticationAction() {
    }

    public void setDuoContextLookupStrategy(@Nonnull Function<ProfileRequestContext, DuoOIDCAuthenticationContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.duoContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"DuoContextLookuplookup strategy cannot be null");
    }

    protected final boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.duoContext = this.duoContextLookupStrategy.apply(profileRequestContext);
        if (this.duoContext == null) {
            this.log.warn("{} No Duo context returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        return this.doPreExecute(profileRequestContext, authenticationContext, this.duoContext);
    }

    protected final void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        this.doExecute(profileRequestContext, authenticationContext, this.duoContext);
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull DuoOIDCAuthenticationContext context) {
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull DuoOIDCAuthenticationContext context) {
    }
}

