/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.duo;

import java.security.Principal;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.duo.DuoIntegration;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public class BasicDuoIntegration
extends AbstractInitializableComponent
implements DuoIntegration {
    @NonnullAfterInit
    @NotEmpty
    private String apiHost;
    @Nullable
    @NotEmpty
    private String applicationKey;
    @NonnullAfterInit
    @NotEmpty
    private String integrationKey;
    @NonnullAfterInit
    @NotEmpty
    private String secretKey;
    @Nonnull
    private final Subject supportedPrincipals = new Subject();

    @Override
    @Nonnull
    @NotEmpty
    public String getAPIHost() {
        this.checkComponentActive();
        assert (this.apiHost != null);
        return this.apiHost;
    }

    public void setAPIHost(@Nonnull @NotEmpty String host) {
        this.checkSetterPreconditions();
        this.apiHost = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)host), (String)"API host cannot be null or empty");
    }

    @Override
    @Nullable
    @NotEmpty
    public String getApplicationKey() {
        return this.applicationKey;
    }

    public void setApplicationKey(@Nullable @NotEmpty String key) {
        this.checkSetterPreconditions();
        this.applicationKey = StringSupport.trimOrNull((String)key);
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getIntegrationKey() {
        this.checkComponentActive();
        assert (this.integrationKey != null);
        return this.integrationKey;
    }

    public void setIntegrationKey(@Nonnull @NotEmpty String key) {
        this.checkSetterPreconditions();
        this.integrationKey = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)key), (String)"Integration key cannot be null or empty");
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getSecretKey() {
        this.checkComponentActive();
        assert (this.secretKey != null);
        return this.secretKey;
    }

    public void setSecretKey(@Nonnull @NotEmpty String key) {
        this.checkSetterPreconditions();
        this.secretKey = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)key), (String)"Secret key cannot be null or empty");
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public <T extends Principal> Set<T> getSupportedPrincipals(@Nonnull Class<T> c) {
        Set<T> result = this.supportedPrincipals.getPrincipals(c);
        assert (result != null);
        return result;
    }

    public <T extends Principal> void setSupportedPrincipals(@Nullable Collection<T> principals) {
        this.checkSetterPreconditions();
        this.supportedPrincipals.getPrincipals().clear();
        if (principals != null && !principals.isEmpty()) {
            this.supportedPrincipals.getPrincipals().addAll(Set.copyOf(principals));
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (this.apiHost == null || this.integrationKey == null || this.secretKey == null) {
            throw new ComponentInitializationException("API host and integration keys must be set");
        }
    }
}

