/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.PasswordlessCookieManager;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class PostValidatePasswordlessEvaluation
extends AbstractAuthenticationAction {
    @Nonnull
    @NotEmpty
    public static final String PROMPT_USER_EVENT = "PasswordlessPrompt";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PostValidatePasswordlessEvaluation.class);
    @Nullable
    private Consumer<ProfileRequestContext> cleanupHook;
    @Nonnull
    private Predicate<ProfileRequestContext> passwordlessCondition = PredicateSupport.alwaysFalse();
    @NonnullAfterInit
    private PasswordlessCookieManager cookieManager;
    private boolean requireResultCacheable = true;
    private boolean detectUsernameMismatch = true;

    public void setCleanupHook(@Nullable Consumer<ProfileRequestContext> hook) {
        this.checkSetterPreconditions();
        this.cleanupHook = hook;
    }

    public void setPasswordlessCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.passwordlessCondition = (Predicate)Constraint.isNotNull(condition, (String)"Passwordless eligibility condition cannot be null");
    }

    public void setCookieManager(@Nullable PasswordlessCookieManager manager) {
        this.checkSetterPreconditions();
        this.cookieManager = (PasswordlessCookieManager)Constraint.isNotNull((Object)manager, (String)"PasswordlessCookieManager cannot be null");
    }

    public void setRequireResultCacheable(boolean flag) {
        this.checkSetterPreconditions();
        this.requireResultCacheable = flag;
    }

    public void setDetectUsernameMismatch(boolean flag) {
        this.checkSetterPreconditions();
        this.detectUsernameMismatch = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.cookieManager == null) {
            throw new ComponentInitializationException("PasswordlessCookieManager cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        String username = this.getUsername(profileRequestContext, authenticationContext);
        if (username == null) {
            return;
        }
        if (!authenticationContext.isResultCacheable() && this.requireResultCacheable) {
            this.log.debug("{} Non-cacheable authentication, clearing guard cookie if set", (Object)this.getLogPrefix());
            this.cookieManager.clearCookie();
            return;
        }
        if (this.cookieManager.isOptOut()) {
            this.log.debug("{} Opt-out cookie found, skipping prompt for '{}'", (Object)this.getLogPrefix(), (Object)username);
            return;
        }
        String cookie = this.cookieManager.readCookie();
        if (cookie != null) {
            if (username.equals(cookie)) {
                this.log.debug("{} Refreshing passwordless cookie for '{}' if set", (Object)this.getLogPrefix(), (Object)username);
                if (!this.cookieManager.refreshCookie()) {
                    this.log.warn("{} Unable to refresh passwordless cookie for '{}'", (Object)this.getLogPrefix(), (Object)username);
                }
                return;
            }
            if (this.detectUsernameMismatch) {
                this.log.info("{} Clearing existing guard cookie for original username '{}'", (Object)this.getLogPrefix(), (Object)cookie);
                this.cookieManager.clearCookie();
            } else {
                this.log.info("{} Ignoring username mismatch, left guard cookie for original username '{}'", (Object)this.getLogPrefix(), (Object)cookie);
                return;
            }
        }
        if (this.passwordlessCondition.test(profileRequestContext)) {
            this.log.info("{} User '{}' eligible for passwordless, advancing to opt-in view", (Object)this.getLogPrefix(), (Object)username);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)PROMPT_USER_EVENT);
        } else {
            this.log.debug("{} User '{}' not eligible for passwordless", (Object)this.getLogPrefix(), (Object)username);
        }
    }

    protected void doPostExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        super.doPostExecute(profileRequestContext);
        if (this.cleanupHook != null) {
            this.cleanupHook.accept(profileRequestContext);
        }
    }

    @Nullable
    private String getUsername(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        DuoOIDCAuthenticationContext duoContext = (DuoOIDCAuthenticationContext)authenticationContext.getSubcontext(DuoOIDCAuthenticationContext.class);
        if (duoContext == null) {
            this.log.error("{} No DuoOIDCAuthenticationContext available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return null;
        }
        String username = duoContext.getUsername();
        if (username == null) {
            this.log.error("{} No username available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return null;
        }
        return username;
    }
}

