/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.PasswordlessCookieManager;
import net.shibboleth.idp.plugin.authn.duo.context.DuoPasswordlessContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class PopulatePasswordlessContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulatePasswordlessContext.class);
    @Nonnull
    private Function<ProfileRequestContext, DuoPasswordlessContext> duoPasswordlessContextLookupStrategy = new ChildContextLookup(DuoPasswordlessContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));
    @NonnullAfterInit
    private PasswordlessCookieManager cookieManager;
    @NonnullBeforeExec
    private DuoPasswordlessContext passwordlessContext;

    public void setDuoPasswordlessContextLookupStrategy(@Nonnull Function<ProfileRequestContext, DuoPasswordlessContext> strategy) {
        this.checkSetterPreconditions();
        this.duoPasswordlessContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"DuoPasswordlessContext lookup strategy cannot be null");
    }

    public void setCookieManager(@Nullable PasswordlessCookieManager manager) {
        this.checkSetterPreconditions();
        this.cookieManager = (PasswordlessCookieManager)Constraint.isNotNull((Object)manager, (String)"PasswordlessCookieManager cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.cookieManager == null) {
            throw new ComponentInitializationException("PasswordlessCookieManager cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"RequestUnsupported");
            return false;
        }
        this.passwordlessContext = this.duoPasswordlessContextLookupStrategy.apply(profileRequestContext);
        if (this.passwordlessContext == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.passwordlessContext.getUsername() != null) {
            this.log.debug("{} Pre-existing username for passwordless authentication: {}", (Object)this.getLogPrefix(), (Object)this.passwordlessContext.getUsername());
            return;
        }
        if (this.cookieManager.isOptOut()) {
            this.log.debug("{} Guard cookie indicates opt-out", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"ReselectFlow");
            return;
        }
        String username = this.cookieManager.readCookie();
        if (username == null) {
            this.log.debug("{} Guard cookie missing or unreadable", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"RequestUnsupported");
            return;
        }
        this.passwordlessContext.setUsername(username);
        this.log.debug("{} Extracted username for passwordless authentication from cookie: {}", (Object)this.getLogPrefix(), (Object)username);
    }
}

