/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import jakarta.servlet.http.HttpServletRequest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.plugin.authn.duo.PasswordlessCookieManager;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class CreatePasswordlessCookie
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String OPTIN_FIELD_NAME = "optin";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CreatePasswordlessCookie.class);
    @NonnullAfterInit
    private PasswordlessCookieManager cookieManager;

    public void setCookieManager(@Nullable PasswordlessCookieManager manager) {
        this.checkSetterPreconditions();
        this.cookieManager = (PasswordlessCookieManager)Constraint.isNotNull((Object)manager, (String)"PasswordlessCookieManager cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.cookieManager == null) {
            throw new ComponentInitializationException("PasswordlessCookieManager cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String username;
        String optin;
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            this.log.error("{} HttpServletRequest absent, assuming opt-out", (Object)this.getLogPrefix());
            optin = "0";
        } else {
            optin = request.getParameter(OPTIN_FIELD_NAME);
        }
        if (!"1".equals(optin)) {
            if (!this.cookieManager.writeCookie(null)) {
                this.log.warn("{} Failed to create passwordless cookie for opt-out", (Object)this.getLogPrefix());
            }
            return;
        }
        SubjectCanonicalizationContext c14nContext = (SubjectCanonicalizationContext)profileRequestContext.getSubcontext(SubjectCanonicalizationContext.class);
        String string = username = c14nContext != null ? c14nContext.getPrincipalName() : null;
        if (username == null) {
            this.log.error("{} No username available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubjectCanonicalizationContext");
            return;
        }
        this.log.debug("{} Creating passwordless cookie for username '{}'", (Object)this.getLogPrefix(), (Object)username);
        if (!this.cookieManager.writeCookie(username)) {
            this.log.warn("{} Failed to create passwordless cookie for username '{}'", (Object)this.getLogPrefix(), (Object)username);
        }
    }
}

