/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
@ThreadSafe
@Immutable
public final class WebAuthnCredential {
    @JsonProperty(value="credential_name")
    @Nullable
    private final String credentialName;
    @JsonProperty(value="date_added")
    @Nullable
    private final Integer dateAdded;
    @JsonProperty(value="date_last_used")
    @Nullable
    private final Integer dateLastUsed;
    @JsonProperty(value="label")
    @Nullable
    private final String label;
    @JsonProperty(value="webauthnkey")
    @Nullable
    private final String webauthnkey;
    @JsonProperty(value="passwordless_authorized")
    @Nullable
    private final Boolean passwordlessAuthorized;
    @JsonProperty(value="backup_eligible")
    @Nullable
    private final Boolean backupEligible;
    @JsonProperty(value="backup_status")
    @Nullable
    private final Boolean backupStatus;
    @JsonProperty(value="aaguid")
    @Nullable
    private final String aaguid;
    @JsonProperty(value="registered_as")
    @Nullable
    private final String registeredAs;
    @JsonProperty(value="transports")
    @Nullable
    private final List<String> transports;
    @JsonProperty(value="uv_capable")
    @Nullable
    private final Boolean uvCapable;
    @JsonIgnore
    @Nonnull
    @NotLive
    @Unmodifiable
    private final Map<String, Object> additionalProperties;

    private WebAuthnCredential(Builder builder) {
        this.credentialName = builder.credentialName;
        this.dateAdded = builder.dateAdded;
        this.label = builder.label;
        this.webauthnkey = builder.webauthnkey;
        this.uvCapable = builder.uvCapable;
        this.dateLastUsed = builder.dateLastUsed;
        this.passwordlessAuthorized = builder.passwordlessAuthorized;
        this.backupEligible = builder.backupEligible;
        this.backupStatus = builder.backupStatus;
        this.aaguid = builder.aaguid;
        this.registeredAs = builder.registeredAs;
        this.transports = builder.transports;
        this.additionalProperties = CollectionSupport.copyToMap(builder.additionalProperties);
    }

    @JsonProperty(value="credential_name")
    @Nullable
    public String getCredentialName() {
        return this.credentialName;
    }

    @JsonProperty(value="date_added")
    @Nullable
    public Integer getDateAdded() {
        return this.dateAdded;
    }

    @JsonProperty(value="label")
    @Nullable
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="webauthnkey")
    @Nullable
    public String getWebauthnkey() {
        return this.webauthnkey;
    }

    @JsonProperty(value="uv_capable")
    @Nullable
    public Boolean isUvCapable() {
        return this.uvCapable;
    }

    @JsonProperty(value="date_last_used")
    @Nullable
    public Integer getDateLastUsed() {
        return this.dateLastUsed;
    }

    @JsonProperty(value="aaguid")
    public String getAaguid() {
        return this.aaguid;
    }

    @JsonProperty(value="backup_eligible")
    public Boolean isBackupEligible() {
        return this.backupEligible;
    }

    @JsonProperty(value="backup_status")
    public Boolean isBackupStatus() {
        return this.backupStatus;
    }

    @JsonProperty(value="passwordless_authorized")
    public Boolean isPasswordlessAuthorized() {
        return this.passwordlessAuthorized;
    }

    @JsonProperty(value="registered_as")
    public String getRegisteredAs() {
        return this.registeredAs;
    }

    @JsonProperty(value="transports")
    public List<String> getTransports() {
        return this.transports;
    }

    @JsonIgnore
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    public static final class Builder {
        private String credentialName;
        private Integer dateAdded;
        private Integer dateLastUsed;
        private String label;
        private String webauthnkey;
        private Boolean uvCapable;
        private Boolean passwordlessAuthorized;
        private Boolean backupEligible;
        private Boolean backupStatus;
        private String aaguid;
        private String registeredAs;
        private List<String> transports;
        @Nonnull
        private final Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @JsonProperty(value="credential_name")
        public Builder withCredentialName(@Nullable String name) {
            this.credentialName = name;
            return this;
        }

        @JsonProperty(value="date_added")
        public Builder withDateAdded(@Nullable Integer date) {
            this.dateAdded = date;
            return this;
        }

        @JsonProperty(value="label")
        public Builder withLabel(@Nullable String labelIn) {
            this.label = labelIn;
            return this;
        }

        @JsonProperty(value="webauthnkey")
        public Builder withWebauthnkey(@Nullable String key) {
            this.webauthnkey = key;
            return this;
        }

        @JsonProperty(value="uv_capable")
        public Builder withUvCapable(@Nullable Boolean flag) {
            this.uvCapable = flag;
            return this;
        }

        @JsonProperty(value="passwordless_authorized")
        public Builder withPasswordlessAuthorized(@Nullable Boolean flag) {
            this.passwordlessAuthorized = flag;
            return this;
        }

        @JsonProperty(value="backup_eligible")
        public Builder withBackupEligible(@Nullable Boolean flag) {
            this.backupEligible = flag;
            return this;
        }

        @JsonProperty(value="backup_status")
        public Builder withBackupStatus(@Nullable Boolean flag) {
            this.backupStatus = flag;
            return this;
        }

        @JsonProperty(value="aaguid")
        public Builder withAaguid(@Nullable String guid) {
            this.aaguid = guid;
            return this;
        }

        @JsonProperty(value="registered_as")
        public Builder withRegisteredAs(@Nullable String regAs) {
            this.registeredAs = regAs;
            return this;
        }

        @JsonProperty(value="transports")
        public Builder withTransports(@Nullable List<String> trans) {
            this.transports = trans;
            return this;
        }

        @JsonAnySetter
        public Builder withAdditionalProperty(@Nonnull String name, @Nullable Object value) {
            if (value != null) {
                this.additionalProperties.put(name, value);
            }
            return this;
        }

        public WebAuthnCredential build() {
            return new WebAuthnCredential(this);
        }
    }
}

