/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.audit;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafe
public abstract class AbstractDuoAuditExtractor<T>
implements Function<ProfileRequestContext, T> {
    @Override
    @Nullable
    public T apply(@Nullable ProfileRequestContext profileRequestContext) {
        if (profileRequestContext == null) {
            return null;
        }
        AuthenticationContext authnContext = (AuthenticationContext)profileRequestContext.getSubcontext(AuthenticationContext.class);
        if (authnContext == null) {
            return null;
        }
        DuoOIDCAuthenticationContext duoContext = (DuoOIDCAuthenticationContext)authnContext.getSubcontext(DuoOIDCAuthenticationContext.class);
        if (duoContext == null) {
            return null;
        }
        return this.doLookup(duoContext);
    }

    @Nullable
    protected abstract T doLookup(@Nonnull DuoOIDCAuthenticationContext var1);
}

