/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.duo;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.principal.CloneablePrincipal;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public class DuoPrincipal
implements CloneablePrincipal {
    @Nonnull
    @NotEmpty
    private String username;

    public DuoPrincipal(@Nonnull @ParameterName(name="name") @NotEmpty String name) {
        this.username = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Username cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getName() {
        return this.username;
    }

    public int hashCode() {
        return this.username.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof DuoPrincipal) {
            DuoPrincipal otherPrincipal = (DuoPrincipal)other;
            return this.username.equals(otherPrincipal.getName());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("username", (Object)this.username).toString();
    }

    @Nonnull
    public DuoPrincipal clone() throws CloneNotSupportedException {
        DuoPrincipal copy = (DuoPrincipal)super.clone();
        copy.username = this.username;
        return copy;
    }
}

