/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.AbstractDuoAuthenticationAction;
import net.shibboleth.idp.plugin.authn.duo.DuoException;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateTokenClaims
extends AbstractDuoAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateTokenClaims.class);
    @NonnullBeforeExec
    private JWTClaimsSet claimsSet;
    @Nullable
    private Consumer<ProfileRequestContext> cleanupHook;
    @NonnullAfterInit
    private ClaimsValidator claimsValidator;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.claimsValidator == null) {
            throw new ComponentInitializationException("Duo ClaimSet Validator cannot be null");
        }
    }

    public void setCleanupHook(@Nullable Consumer<ProfileRequestContext> hook) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.cleanupHook = hook;
    }

    public void setClaimsValidator(@Nonnull ClaimsValidator validator) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.claimsValidator = (ClaimsValidator)Constraint.isNotNull((Object)validator, (String)"Claims validator cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull DuoOIDCAuthenticationContext duoContext) {
        JWT token = duoContext.getAuthToken();
        if (token == null) {
            this.log.error("{} Duo 2FA token is not available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        try {
            this.claimsSet = token.getJWTClaimsSet();
            if (this.claimsSet == null) {
                throw new DuoException("Duo JWT ClaimsSet is null");
            }
        }
        catch (ParseException | DuoException e) {
            this.log.error("{} Claimset of Duo 2FA token is not available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull DuoOIDCAuthenticationContext duoContext) {
        this.log.debug("{} Validating token claims for subject '{}'", (Object)this.getLogPrefix(), (Object)this.claimsSet.getSubject());
        try {
            this.claimsValidator.validate(this.claimsSet, profileRequestContext);
            if (this.cleanupHook != null) {
                this.cleanupHook.accept(profileRequestContext);
            }
        }
        catch (JWTValidationException e) {
            this.log.error("{} Token verification failed for subject '{}'", new Object[]{this.getLogPrefix(), this.claimsSet.getSubject(), e});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            if (this.cleanupHook != null) {
                this.cleanupHook.accept(profileRequestContext);
            }
            return;
        }
        this.log.debug("{} Token claims are valid for subject '{}'", (Object)this.getLogPrefix(), (Object)this.claimsSet.getSubject());
    }

    public static class DuoOIDAuthenticationContextCleanupHook
    implements Consumer<ProfileRequestContext> {
        @Override
        public void accept(@Nullable ProfileRequestContext input) {
            DuoOIDCAuthenticationContext duoCtx;
            AuthenticationContext authnCtx;
            if (input != null && (authnCtx = (AuthenticationContext)input.getSubcontext(AuthenticationContext.class)) != null && (duoCtx = (DuoOIDCAuthenticationContext)authnCtx.getSubcontext(DuoOIDCAuthenticationContext.class)) != null) {
                duoCtx.setNonce(null);
            }
        }
    }
}

