/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import java.security.Principal;
import java.text.ParseException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.duo.DuoFactorPrincipal;
import net.shibboleth.idp.authn.duo.DuoPrincipal;
import net.shibboleth.idp.authn.impl.AbstractAuditingValidationAction;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.plugin.authn.duo.DuoException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateDuoTokenAuthenticationResult
extends AbstractAuditingValidationAction {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.plugin.authn.duo";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateDuoTokenAuthenticationResult.class);
    @Nullable
    private Function<ProfileRequestContext, Collection<Principal>> contextToPrincipalMappingStrategy;
    @Nullable
    private ProfileRequestContext prc;
    @NonnullBeforeExec
    private DuoOIDCAuthenticationContext duoContext;
    @NonnullBeforeExec
    private DuoOIDCIntegration duoIntegration;
    @NonnullBeforeExec
    private JWTClaimsSet claimsSet;
    @NonnullBeforeExec
    @NotEmpty
    private String username;
    @Nullable
    private String factorUsed;

    public ValidateDuoTokenAuthenticationResult() {
        this.setMetricName(DEFAULT_METRIC_NAME);
    }

    @Nullable
    public Function<ProfileRequestContext, Collection<Principal>> getContextToPrincipalMappingStrategy() {
        return this.contextToPrincipalMappingStrategy;
    }

    public void setContextToPrincipalMappingStrategy(@Nullable Function<ProfileRequestContext, Collection<Principal>> hook) {
        this.checkSetterPreconditions();
        this.contextToPrincipalMappingStrategy = hook;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.prc = profileRequestContext;
        this.duoContext = (DuoOIDCAuthenticationContext)authenticationContext.getSubcontext(DuoOIDCAuthenticationContext.class);
        if (this.duoContext == null) {
            this.log.error("{} No DuoAuthenticationContext available", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "No DuoAuthenticationContext context available", "InvalidAuthenticationContext");
            this.recordFailure(profileRequestContext);
            return false;
        }
        this.duoIntegration = this.duoContext.getIntegration();
        if (this.duoIntegration == null) {
            this.log.error("{} No Duo Integration available", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "No Duo integration available", "InvalidAuthenticationContext");
            this.recordFailure(profileRequestContext);
            return false;
        }
        this.username = this.duoContext.getUsername();
        if (this.username == null) {
            this.log.error("{} Duo username is not available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            this.recordFailure(profileRequestContext);
            return false;
        }
        JWT token = this.duoContext.getAuthToken();
        if (token == null) {
            this.log.error("{} Duo 2FA token is not available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            this.recordFailure(profileRequestContext);
            return false;
        }
        try {
            this.claimsSet = token.getJWTClaimsSet();
            if (this.claimsSet == null) {
                throw new DuoException("Duo JWT ClaimsSet is null");
            }
        }
        catch (ParseException | DuoException e) {
            this.log.error("{} Claimset of Duo 2FA token is not available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            this.recordFailure(profileRequestContext);
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Map authStatusObject = null;
        try {
            authStatusObject = this.claimsSet.getJSONObjectClaim("auth_result");
            if (authStatusObject == null) {
                throw new DuoException("Authentication result object is null");
            }
        }
        catch (ParseException | DuoException e) {
            this.log.error("{} Duo 2FA authentication failed for '{}', auth_result missing", (Object)this.getLogPrefix(), (Object)this.username);
            this.handleError(profileRequestContext, authenticationContext, "AuthenticationException", "AuthenticationException");
            this.recordFailure(profileRequestContext);
            return;
        }
        Object statusObj = authStatusObject.get("status");
        Object statusMsgObj = authStatusObject.get("status_msg");
        if (statusObj instanceof String) {
            String authResultStatus = (String)statusObj;
            if (statusMsgObj instanceof String) {
                String authResultStatusMsg = (String)statusMsgObj;
                if ("allow".equalsIgnoreCase(authResultStatus)) {
                    this.extractClaims();
                    this.factorUsed = this.duoContext.getFactorUsed();
                    Set allowedFactors = this.duoIntegration.getAllowedFactors();
                    if (allowedFactors != null && !allowedFactors.contains(this.factorUsed)) {
                        this.log.error("{} Duo 2FA authentication failed for '{}', factor '{}' disallowed", new Object[]{this.getLogPrefix(), this.username, this.factorUsed});
                        this.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
                        this.recordFailure(profileRequestContext);
                        return;
                    }
                    this.log.info("{} Duo 2FA authentication succeeded for '{}', using second-factor '{}'", new Object[]{this.getLogPrefix(), this.duoContext.getUsername(), this.factorUsed != null ? this.factorUsed : "unspecified"});
                    this.buildAuthenticationResult(profileRequestContext, authenticationContext);
                    this.recordSuccess(profileRequestContext);
                    return;
                }
                if ("deny".equalsIgnoreCase(authResultStatus)) {
                    this.log.error("{} Duo 2FA authentication failed for '{}', 2FA status '{}'", new Object[]{this.getLogPrefix(), this.username, authResultStatusMsg});
                    this.handleError(profileRequestContext, authenticationContext, authResultStatus, "InvalidCredentials");
                    this.recordFailure(profileRequestContext);
                    return;
                }
                this.log.error("{} Duo 2FA authentication failed for '{}', unknown response", (Object)this.getLogPrefix(), (Object)this.username);
                this.handleError(profileRequestContext, authenticationContext, "AuthenticationException", "AuthenticationException");
                this.recordFailure(profileRequestContext);
                return;
            }
        }
        this.log.error("{} Duo 2FA authentication failed for '{}', auth_results missing", (Object)this.getLogPrefix(), (Object)this.username);
        this.handleError(profileRequestContext, authenticationContext, "AuthenticationException", "AuthenticationException");
        this.recordFailure(profileRequestContext);
    }

    private void extractClaims() {
        try {
            Map authnContextClaimObj = this.claimsSet.getJSONObjectClaim("auth_context");
            if (authnContextClaimObj != null) {
                Map device;
                Object keyObj;
                Object deviceClaimObj;
                Object factorClaimObj = authnContextClaimObj.get("factor");
                if (factorClaimObj instanceof String) {
                    String factor = (String)factorClaimObj;
                    this.duoContext.setFactorUsed(factor);
                }
                if ((deviceClaimObj = authnContextClaimObj.get("auth_device")) instanceof Map && (keyObj = (device = (Map)deviceClaimObj).get("key")) instanceof String) {
                    String key = (String)keyObj;
                    this.duoContext.setDeviceKey(key);
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        Collection<Principal> mapped;
        String localFactor;
        String localUsername = this.username;
        assert (localUsername != null);
        subject.getPrincipals().add((Principal)new DuoPrincipal(localUsername));
        if (this.duoIntegration.isPasswordless()) {
            subject.getPrincipals().add((Principal)new UsernamePrincipal(localUsername));
        }
        if ((localFactor = this.factorUsed) != null) {
            subject.getPrincipals().add((Principal)new DuoFactorPrincipal(localFactor));
            this.log.trace("{} Added DuoFactorPrincipal '{}' to DuoPrincipal '{}'", new Object[]{this.getLogPrefix(), localFactor, localUsername});
        }
        subject.getPrincipals().addAll(this.duoIntegration.getSupportedPrincipals(Principal.class));
        Function<ProfileRequestContext, Collection<Principal>> contextToPrincipalStrategy = this.duoIntegration.getContextToPrincipalMappingStrategy();
        if (contextToPrincipalStrategy != null && (mapped = contextToPrincipalStrategy.apply(this.prc)) != null) {
            subject.getPrincipals().addAll(mapped);
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} Added mapped Principals: {}", (Object)this.getLogPrefix(), mapped.stream().map(Principal::getName).collect(Collectors.toUnmodifiableList()));
            }
        }
        if ((contextToPrincipalStrategy = this.getContextToPrincipalMappingStrategy()) != null && (mapped = contextToPrincipalStrategy.apply(this.prc)) != null) {
            subject.getPrincipals().addAll(mapped);
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} Added mapped Principals: {}", (Object)this.getLogPrefix(), mapped.stream().map(Principal::getName).collect(Collectors.toUnmodifiableList()));
            }
        }
        return subject;
    }

    protected void buildAuthenticationResult(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        super.buildAuthenticationResult(profileRequestContext, authenticationContext);
        ((SubjectCanonicalizationContext)profileRequestContext.ensureSubcontext(SubjectCanonicalizationContext.class)).setPrincipalName(this.username);
    }
}

