/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.admin.impl;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.duo.admin.impl.AdminFlowDescriptor;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.logic.AbstractRelyingPartyPredicate;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.security.AccessControlService;
import org.opensaml.profile.context.ProfileRequestContext;

public class AdminAccessPredicate
extends AbstractRelyingPartyPredicate {
    @NonnullAfterInit
    private AccessControlService accessControlService;
    @Nullable
    private Supplier<HttpServletRequest> requestSupplier;

    public void setAccessControlService(@Nonnull AccessControlService service) {
        this.accessControlService = (AccessControlService)Constraint.isNotNull((Object)service, (String)"AccessControlService cannot be null");
    }

    public void setHttpServletRequestSupplier(@Nonnull Supplier<HttpServletRequest> supplier) {
        this.requestSupplier = (Supplier)Constraint.isNotNull(supplier, (String)"HttpServletRequest supplier cannot be null");
    }

    public boolean test(@Nullable ProfileRequestContext input) {
        AdminFlowDescriptor duo;
        String policy;
        ProfileConfiguration profileConfiguration;
        RelyingPartyContext rpCtx;
        HttpServletRequest request;
        HttpServletRequest httpServletRequest = request = this.requestSupplier != null ? this.requestSupplier.get() : null;
        if (request != null && (rpCtx = this.getRelyingPartyContext(input)) != null && (profileConfiguration = rpCtx.getProfileConfig()) instanceof AdminFlowDescriptor && (policy = (duo = (AdminFlowDescriptor)profileConfiguration).getAdminPolicyName(input)) != null) {
            return this.accessControlService.getInstance(policy).checkAccess((ServletRequest)request, "write", "cookie");
        }
        return false;
    }
}

