/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo;

import java.security.Principal;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.security.auth.Subject;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

@Deprecated(forRemoval=true, since="2.1.0")
@ThreadSafe
public final class SimpleDuoOIDCIntegration
extends AbstractInitializableComponent
implements DuoOIDCIntegration {
    @GuardedBy(value="this")
    private boolean passwordless;
    @GuardedBy(value="this")
    @NonnullAfterInit
    @NotEmpty
    private String apiHost;
    @GuardedBy(value="this")
    @NonnullAfterInit
    @NotEmpty
    private String clientId;
    @GuardedBy(value="this")
    @NonnullAfterInit
    @NotEmpty
    private String secretKey;
    @Nullable
    @GuardedBy(value="this")
    private String redirectURI;
    @GuardedBy(value="this")
    @NonnullAfterInit
    @NotEmpty
    private String healthEndpoint;
    @GuardedBy(value="this")
    @NonnullAfterInit
    @NotEmpty
    private String authorizeEndpoint;
    @GuardedBy(value="this")
    @NonnullAfterInit
    @NotEmpty
    private String tokenEndpoint;
    @Nonnull
    @GuardedBy(value="this")
    private final Subject supportedPrincipals = new Subject();

    public synchronized void setPasswordless(boolean flag) {
        this.checkSetterPreconditions();
        this.passwordless = flag;
    }

    @Override
    public synchronized boolean isPasswordless() {
        this.checkComponentActive();
        return this.passwordless;
    }

    @Override
    @Nonnull
    @NotEmpty
    public synchronized String getAPIHost() {
        this.checkComponentActive();
        assert (this.apiHost != null);
        return this.apiHost;
    }

    public synchronized void setAPIHost(@Nonnull @NotEmpty String host) {
        this.checkSetterPreconditions();
        this.apiHost = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)host), (String)"API host cannot be null or empty");
    }

    @Override
    @Nonnull
    @NotEmpty
    public synchronized String getHealthCheckEndpoint() {
        this.checkComponentActive();
        assert (this.healthEndpoint != null);
        return this.healthEndpoint;
    }

    public synchronized void setHealthCheckEndpoint(@Nonnull @NotEmpty String endpoint) {
        this.checkSetterPreconditions();
        this.healthEndpoint = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)endpoint), (String)"Health check endpoint cannot be null or empty");
    }

    @Override
    @Nonnull
    @NotEmpty
    public synchronized String getAuthorizeEndpoint() {
        this.checkComponentActive();
        assert (this.authorizeEndpoint != null);
        return this.authorizeEndpoint;
    }

    public synchronized void setAuthorizeEndpoint(@Nonnull @NotEmpty String endpoint) {
        this.checkSetterPreconditions();
        this.authorizeEndpoint = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)endpoint), (String)"Authorize endpoint cannot be null or empty");
    }

    @Override
    @Nonnull
    @NotEmpty
    public synchronized String getTokenEndpoint() {
        this.checkComponentActive();
        assert (this.tokenEndpoint != null);
        return this.tokenEndpoint;
    }

    public synchronized void setTokenEndpoint(@Nonnull @NotEmpty String endpoint) {
        this.checkSetterPreconditions();
        this.tokenEndpoint = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)endpoint), (String)"Token endpoint cannot be null or empty");
    }

    @Override
    @Nullable
    public synchronized String getRedirectURI() {
        return this.redirectURI;
    }

    public synchronized void setRedirectURI(@Nonnull String url) {
        this.checkSetterPreconditions();
        this.redirectURI = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)url), (String)"Redirect URI cannot be null or empty");
    }

    public synchronized void setClientId(@Nonnull @NotEmpty String id) {
        this.checkSetterPreconditions();
        this.clientId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"ClientID cannot be null or empty");
    }

    @Override
    @Nonnull
    @NotEmpty
    public synchronized String getClientId() {
        this.checkComponentActive();
        assert (this.clientId != null);
        return this.clientId;
    }

    public synchronized void setSecretKey(@Nonnull @NotEmpty String key) {
        this.checkSetterPreconditions();
        this.secretKey = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)key), (String)"Secret key cannot be null or empty");
    }

    @Override
    @Nonnull
    @NotEmpty
    public synchronized String getSecretKey() {
        this.checkComponentActive();
        assert (this.secretKey != null);
        return this.secretKey;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public synchronized <T extends Principal> Set<T> getSupportedPrincipals(@Nonnull Class<T> c) {
        return this.supportedPrincipals.getPrincipals(c);
    }

    public synchronized <T extends Principal> void setSupportedPrincipals(@Nullable @NonnullElements Collection<T> principals) {
        this.checkSetterPreconditions();
        this.supportedPrincipals.getPrincipals().clear();
        if (principals != null && !principals.isEmpty()) {
            this.supportedPrincipals.getPrincipals().addAll(Set.copyOf(principals));
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (this.apiHost == null || this.clientId == null || this.secretKey == null || this.healthEndpoint == null || this.authorizeEndpoint == null || this.tokenEndpoint == null || this.redirectURI == null) {
            throw new ComponentInitializationException("API host, clientId, secret key,token endpoint, health check endpoint, authorization endpoint, and redirectURI must be set");
        }
    }

    public int hashCode() {
        return Objects.hash(this.getClientId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleDuoOIDCIntegration other = (SimpleDuoOIDCIntegration)obj;
        return Objects.equals(this.getClientId(), other.getClientId());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DefaultDuoOIDCIntegration [apiHost=");
        builder.append(this.apiHost);
        builder.append(", clientId=");
        builder.append(this.clientId);
        builder.append(", redirectURI=");
        builder.append(this.redirectURI);
        builder.append("]");
        return builder.toString();
    }
}

