/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo;

import com.google.common.net.UrlEscapers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.net.CookieManager;
import net.shibboleth.shared.net.URISupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import org.slf4j.Logger;

public class PasswordlessCookieManager
extends AbstractInitializableComponent {
    @Nonnull
    @NotEmpty
    public static final String NEGATIVE_VALUE = "__NO";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PasswordlessCookieManager.class);
    @Nullable
    @NotEmpty
    private String cookieName;
    @Nullable
    private CookieManager cookieManager;
    @Nullable
    private DataSealer dataSealer;
    private boolean active;

    public void setCookieName(@Nullable String name) {
        this.checkSetterPreconditions();
        this.cookieName = StringSupport.trimOrNull((String)name);
    }

    public void setCookieManager(@Nullable CookieManager manager) {
        this.checkSetterPreconditions();
        this.cookieManager = manager;
    }

    public void setDataSealer(@Nullable DataSealer sealer) {
        this.checkSetterPreconditions();
        this.dataSealer = sealer;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.active = this.cookieName != null && this.cookieManager != null && this.dataSealer != null;
    }

    public boolean isOptOut() {
        this.checkComponentActive();
        if (!this.active) {
            return false;
        }
        assert (this.cookieManager != null);
        assert (this.cookieName != null);
        String value = this.cookieManager.getCookieValue(this.cookieName, null);
        return NEGATIVE_VALUE.equals(value);
    }

    @Nullable
    @NotEmpty
    public String readCookie() {
        this.checkComponentActive();
        if (!this.active) {
            return null;
        }
        assert (this.cookieManager != null);
        assert (this.cookieName != null);
        String wrapped = this.cookieManager.getCookieValue(this.cookieName, null);
        if (wrapped == null) {
            return null;
        }
        if (NEGATIVE_VALUE.equals(wrapped)) {
            return null;
        }
        if ((wrapped = URISupport.doURLDecode((String)wrapped)) == null) {
            this.log.error("Error decoding unwrapped cookie value");
            return null;
        }
        try {
            assert (this.dataSealer != null);
            return this.dataSealer.unwrap(wrapped);
        }
        catch (DataSealerException e) {
            this.log.warn("Unable to unwrap sealed cookie", (Throwable)e);
            return null;
        }
    }

    public boolean writeCookie(@Nullable String username) {
        this.checkComponentActive();
        if (!this.active) {
            return false;
        }
        if (username == null || NEGATIVE_VALUE.equals(username)) {
            assert (this.cookieManager != null);
            assert (this.cookieName != null);
            this.cookieManager.addCookie(this.cookieName, NEGATIVE_VALUE);
            return true;
        }
        try {
            assert (this.dataSealer != null);
            String wrapped = this.dataSealer.wrap(username);
            wrapped = UrlEscapers.urlFormParameterEscaper().escape(wrapped);
            assert (this.cookieManager != null);
            assert (this.cookieName != null);
            assert (wrapped != null);
            this.cookieManager.addCookie(this.cookieName, wrapped);
            return true;
        }
        catch (DataSealerException e) {
            this.log.warn("Unable to wrap username for cookie", (Throwable)e);
            return false;
        }
    }

    public boolean refreshCookie() {
        this.checkComponentActive();
        if (!this.active) {
            return false;
        }
        String username = this.readCookie();
        if (username != null) {
            return this.writeCookie(username);
        }
        return true;
    }

    public void clearCookie() {
        this.checkComponentActive();
        if (!this.active) {
            return;
        }
        assert (this.cookieManager != null);
        assert (this.cookieName != null);
        this.cookieManager.unsetCookie(this.cookieName);
    }
}

