/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.context.DuoPasswordlessContext;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultDuoCleanupHook
extends AbstractInitializableComponent
implements Consumer<ProfileRequestContext> {
    private boolean removePasswordlessContext = true;

    public void setRemovePasswordlessContext(boolean flag) {
        this.checkSetterPreconditions();
        this.removePasswordlessContext = flag;
    }

    @Override
    public void accept(@Nullable ProfileRequestContext input) {
        DuoPasswordlessContext passwordlessCtx;
        AuthenticationContext authnCtx;
        this.checkComponentActive();
        AuthenticationContext authenticationContext = authnCtx = input != null ? (AuthenticationContext)input.getSubcontext(AuthenticationContext.class) : null;
        if (authnCtx == null) {
            return;
        }
        DuoOIDCAuthenticationContext duoCtx = (DuoOIDCAuthenticationContext)authnCtx.getSubcontext(DuoOIDCAuthenticationContext.class);
        if (duoCtx != null) {
            duoCtx.removeFromParent();
        }
        if ((passwordlessCtx = (DuoPasswordlessContext)authnCtx.getSubcontext(DuoPasswordlessContext.class)) != null && this.removePasswordlessContext) {
            passwordlessCtx.removeFromParent();
        }
    }
}

