/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.AbstractDuoAuthenticationAction;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateDuoResponseState
extends AbstractDuoAuthenticationAction {
    @Nonnull
    @NotEmpty
    private final Logger log = LoggerFactory.getLogger(ValidateDuoResponseState.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull DuoOIDCAuthenticationContext duoContext) {
        this.log.trace("{} Duo 2FA request state '{}' was returned in the response as '{}'", new Object[]{this.getLogPrefix(), duoContext.getRequestState(), duoContext.getResponseState()});
        String requestState = duoContext.getRequestState();
        String responseState = duoContext.getResponseState();
        if (requestState == null || responseState == null) {
            this.log.error("{} The state parameter was not present in either the request or response, state is mandatory for Duo 2FA requests", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        if (!requestState.equals(responseState)) {
            this.log.error("{} Duo request state did not match response state, has it been tampered with!", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            this.blankState(duoContext);
            return;
        }
        this.blankState(duoContext);
        this.log.debug("{} Duo 2FA request and response state match, continuing", (Object)this.getLogPrefix());
    }

    private void blankState(@Nonnull DuoOIDCAuthenticationContext context) {
        context.setRequestState(null);
        context.setResponseState(null);
    }
}

