/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.duo.DuoIntegration;
import net.shibboleth.idp.authn.duo.context.DuoAuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.DuoException;
import net.shibboleth.idp.plugin.authn.duo.impl.AbstractDuoAuthenticator;
import net.shibboleth.idp.plugin.authn.duo.impl.DuoPreauthResponse;
import net.shibboleth.idp.plugin.authn.duo.impl.DuoResponseWrapper;
import net.shibboleth.idp.plugin.authn.duo.impl.DuoSupport;
import net.shibboleth.shared.codec.EncodingException;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.net.URIBuilder;

public class DuoPreauthAuthenticator
extends AbstractDuoAuthenticator {
    @Nonnull
    private final TypeReference<DuoResponseWrapper<DuoPreauthResponse>> wrapperTypeRef = new TypeReference<DuoResponseWrapper<DuoPreauthResponse>>(){};

    public DuoPreauthResponse authenticate(@Nonnull DuoAuthenticationContext duoContext, @Nonnull DuoIntegration duoIntegration) throws DuoException {
        try {
            URI uri = new URIBuilder().setScheme("https").setHost(duoIntegration.getAPIHost()).setPath("/auth/v2/preauth").build();
            ClassicRequestBuilder rb = ClassicRequestBuilder.post().setUri(uri).addParameter("username", duoContext.getUsername());
            if (duoContext.getClientAddress() != null) {
                rb.addParameter("ipaddr", duoContext.getClientAddress());
            }
            DuoSupport.signRequest(rb, duoIntegration);
            ClassicHttpRequest request = rb.build();
            return this.doAPIRequest(request, this.wrapperTypeRef).getResponse();
        }
        catch (IOException | URISyntaxException | InvalidKeyException | NoSuchAlgorithmException | EncodingException ex) {
            throw new DuoException("Duo AuthAPI preauth request failed: " + ex.getMessage());
        }
    }
}

