/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.authn.ExternalAuthentication;
import net.shibboleth.idp.authn.ExternalAuthenticationException;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.impl.DuoSupport;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"%{idp.duo.oidc.externalAuthnPath:/Authn/Duo/2FA}"})
@ThreadSafe
public class DuoOIDCAuthnController
extends AbstractInitializableComponent {
    @Nonnull
    @NotEmpty
    public static final String CODE_PARAMETER = "code";
    @Nonnull
    @NotEmpty
    public static final String STATE_PARAMETER = "state";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DuoOIDCAuthnController.class);
    @Nonnull
    @GuardedBy(value="this")
    private Function<ProfileRequestContext, DuoOIDCAuthenticationContext> duoContextLookupStrategy = new ChildContextLookup(DuoOIDCAuthenticationContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));

    public synchronized void setDuoContextLookupStrategy(@Nonnull Function<ProfileRequestContext, DuoOIDCAuthenticationContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.duoContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"DuoContext lookup strategy cannot be null");
    }

    private synchronized Function<ProfileRequestContext, DuoOIDCAuthenticationContext> getDuoContextLookupStrategy() {
        return this.duoContextLookupStrategy;
    }

    @GetMapping(value={"/authorize"})
    public void authorizationRequest(@Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse) throws ExternalAuthenticationException, IOException {
        String key = ExternalAuthentication.startExternalAuthentication((HttpServletRequest)httpRequest);
        ProfileRequestContext prc = ExternalAuthentication.getProfileRequestContext((String)key, (HttpServletRequest)httpRequest);
        DuoOIDCAuthenticationContext duoContext = this.getDuoContextLookupStrategy().apply(prc);
        if (duoContext == null) {
            this.log.error("No Duo context to use in initiating a Duo 2FA request");
            httpRequest.setAttribute("authnError", (Object)"InvalidProfileContext");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        try {
            String authURL;
            DuoOIDCClient client = duoContext.getClient();
            if (client == null) {
                throw new DuoClientException("Duo client is null, has the context been created correctly?");
            }
            String requestState = duoContext.getRequestState();
            DuoOIDCIntegration integration = duoContext.getIntegration();
            String username = duoContext.getUsername();
            if (requestState == null || integration == null || username == null) {
                throw new DuoClientException("Duo request state, username, or integration not set");
            }
            String state = DuoSupport.generateState(requestState, key);
            this.log.info("Starting Duo 2FA for client '{}', user '{}', and unique request state '{}'", new Object[]{duoContext.getIntegration() != null ? integration.getClientId() : "none", duoContext.getUsername(), duoContext.getRequestState()});
            if (client.getCapabilities().isSupportsNonce()) {
                String oidcNonce = DuoSupport.generateNonce(36);
                authURL = client.createAuthUrl(username, state, oidcNonce, duoContext.getRedirectURIOverride());
                duoContext.setNonce(oidcNonce);
            } else {
                authURL = client.createAuthUrl(username, state, null, duoContext.getRedirectURIOverride());
            }
            httpResponse.sendRedirect(authURL);
        }
        catch (DuoClientException e) {
            this.log.error("Could not perform Duo 2FA authorization request", (Throwable)e);
            httpRequest.setAttribute("authnError", (Object)"InvalidProfileContext");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
        }
    }

    @GetMapping(value={"/duo-callback"})
    public void authorizationCallback(@Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse) throws ExternalAuthenticationException, IOException {
        String nonce;
        String key;
        String code = httpRequest.getParameter(CODE_PARAMETER);
        String state = httpRequest.getParameter(STATE_PARAMETER);
        if (state == null || code == null) {
            throw new ExternalAuthenticationException("Duo response must contain a 'code' and 'state' parameter");
        }
        try {
            key = DuoSupport.extractKeyFromState(state);
            nonce = DuoSupport.extractNonceFromState(state);
        }
        catch (DuoException e) {
            throw new ExternalAuthenticationException("Flow execution key component could not be found in the returned state, unable to resume the flow execution", (Exception)((Object)e));
        }
        ProfileRequestContext prc = ExternalAuthentication.getProfileRequestContext((String)key, (HttpServletRequest)httpRequest);
        DuoOIDCAuthenticationContext duoContext = this.getDuoContextLookupStrategy().apply(prc);
        if (duoContext == null) {
            this.log.error("No Duo authentication context to store the Duo 2FA response");
            httpRequest.setAttribute("authnError", (Object)"InvalidProfileContext");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        duoContext.setAuthorizationCode(code);
        duoContext.setResponseState(nonce);
        if (this.log.isInfoEnabled()) {
            DuoOIDCIntegration integration = duoContext.getIntegration();
            this.log.info("Finished Duo 2FA for client '{}', user '{}', and unique request state '{}'", new Object[]{integration != null ? integration.getClientId() : "none", duoContext.getUsername(), nonce});
        }
        ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
    }
}

