/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.nimbus.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.duo.AbstractDuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.model.DuoHealthCheck;
import net.shibboleth.idp.plugin.authn.duo.nimbus.impl.NimbusClientSupport;
import net.shibboleth.idp.plugin.authn.duo.nimbus.impl.TokenResponse;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.net.URIBuilder;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.slf4j.Logger;

@ThreadSafe
@Immutable
public final class NimbusClient
extends AbstractDuoOIDCClient {
    @Nonnull
    @NotEmpty
    private static final String CLIENT_ASSERTION_TYPE = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    @Nonnull
    @NotEmpty
    private static final String HTTPS = "https";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(NimbusClient.class);
    @Nonnull
    private final DuoOIDCIntegration duoIntegration;
    @Nonnull
    private final HttpClient httpClient;
    @Nullable
    private final HttpClientSecurityParameters httpClientSecurityParameters;
    @Nonnull
    private final ObjectMapper objectMapper;

    NimbusClient(@Nonnull DuoOIDCIntegration integration, @Nonnull HttpClient client, @Nullable HttpClientSecurityParameters params, @Nonnull ObjectMapper oMapper) {
        this.duoIntegration = (DuoOIDCIntegration)Constraint.isNotNull((Object)integration, (String)"Nimbus Client requires a non-null Duo Integration");
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"Nimbus Client requires a non-null http client");
        this.httpClientSecurityParameters = params;
        this.objectMapper = oMapper;
    }

    @Nonnull
    public DuoHealthCheck healthCheck() throws DuoClientException {
        try {
            URI uri = new URIBuilder().setScheme(HTTPS).setHost(this.duoIntegration.getAPIHost()).setPath(this.duoIntegration.getHealthCheckEndpoint()).build();
            this.log.trace("Using health check endpoint '{}'", (Object)uri);
            ClassicRequestBuilder rb = ClassicRequestBuilder.post().setUri(uri).addParameter("client_id", this.duoIntegration.getClientId()).addParameter("client_assertion", NimbusClientSupport.createJWS(uri.toString(), this.duoIntegration.getClientId(), this.duoIntegration.getSecretKey()));
            return this.executeRequest(rb.build(), new TypeReference<DuoHealthCheck>(){});
        }
        catch (URISyntaxException e) {
            throw new DuoClientException("Error performing a Duo health check", (Throwable)e);
        }
    }

    @Nonnull
    public String createAuthUrl(@Nonnull @NotEmpty String username, @Nonnull @NotEmpty String state, @Nullable String nonce, @Nullable String redirectURIOverride) throws DuoClientException {
        Constraint.isNotEmpty((String)username, (String)"Username can not be null or empty");
        Constraint.isNotEmpty((String)state, (String)"State can not be null or empty");
        Constraint.isNotEmpty((String)nonce, (String)"Nonce can not be null or empty for this client");
        Constraint.isGreaterThan((int)21, (int)state.length(), (String)"State must be at least 22 characters");
        Constraint.isLessThan((int)1025, (int)state.length(), (String)"State must be at maximum 1024 characters");
        try {
            String redirectURI;
            String string = redirectURI = redirectURIOverride != null ? redirectURIOverride : this.duoIntegration.getRedirectURI();
            if (redirectURI == null) {
                throw new DuoClientException("A redirect_uri was not supplied but is required for creating an authorization request, for client '" + this.duoIntegration.getClientId() + "'");
            }
            String request = NimbusClientSupport.createJWSRequestObject(this.duoIntegration.getClientId(), redirectURI, this.duoIntegration.getSecretKey(), state, username);
            URI uri = new URIBuilder().setScheme(HTTPS).setHost(this.duoIntegration.getAPIHost()).setPath(this.duoIntegration.getAuthorizeEndpoint()).setParameter("scope", "openid").setParameter("nonce", nonce).setParameter("response_type", "code").setParameter("redirect_uri", redirectURI).setParameter("client_id", this.duoIntegration.getClientId()).setParameter("request", request).build();
            return uri.toString();
        }
        catch (URISyntaxException e) {
            throw new DuoClientException("Unable to create a Duo authorization URL", (Throwable)e);
        }
    }

    @Nonnull
    public JWT exchangeAuthorizationCodeFor2FAResult(@Nonnull String code, @Nonnull String username, @Nullable String redirectURIOverride) throws DuoClientException {
        Constraint.isNotEmpty((String)code, (String)"Auth_code can not be null");
        try {
            String redirectURI;
            URI uri = new URIBuilder().setScheme(HTTPS).setHost(this.duoIntegration.getAPIHost()).setPath(this.duoIntegration.getTokenEndpoint()).build();
            this.log.trace("Using authorization endpoint and audience '{}'", (Object)uri);
            String string = redirectURI = redirectURIOverride != null ? redirectURIOverride : this.duoIntegration.getRedirectURI();
            if (redirectURI == null) {
                throw new DuoClientException("A redirect_uri was not supplied but is required for acquiring a 2FA result, for client '" + this.duoIntegration.getClientId() + "'");
            }
            ClassicRequestBuilder rb = ClassicRequestBuilder.post().setUri(uri).addParameter("grant_type", "authorization_code").addParameter("code", code).addParameter("redirect_uri", redirectURI).addParameter("client_assertion_type", CLIENT_ASSERTION_TYPE).addParameter("client_assertion", NimbusClientSupport.createJWS(uri.toString(), this.duoIntegration.getClientId(), this.duoIntegration.getSecretKey()));
            TokenResponse response = this.executeRequest(rb.build(), new TypeReference<TokenResponse>(){});
            this.log.trace("Duo token response: '{}'", (Object)response);
            return SignedJWT.parse((String)response.getIdToken());
        }
        catch (URISyntaxException | ParseException e) {
            throw new DuoClientException("Unable to swap auth_code for id_token", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    private <T> T executeRequest(@Nonnull ClassicHttpRequest request, @Nonnull TypeReference<T> wrapperTypeRef) throws DuoClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isSupportsNonce() {
        return true;
    }
}

