/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.DuoException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClientRegistry;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.DynamicDuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.context.DuoOIDCAuthenticationContext;
import net.shibboleth.idp.plugin.authn.duo.context.DuoPasswordlessContext;
import net.shibboleth.idp.plugin.authn.duo.impl.DuoSupport;
import net.shibboleth.idp.session.context.navigate.CanonicalUsernameLookupStrategy;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class PopulateDuoAuthenticationContext
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateDuoAuthenticationContext.class);
    @Nonnull
    private Function<ProfileRequestContext, DuoPasswordlessContext> passwordlessContextLookupStrategy = new ChildContextLookup(DuoPasswordlessContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));
    @Nonnull
    private Function<ProfileRequestContext, String> usernameLookupStrategy = new CanonicalUsernameLookupStrategy();
    @Nonnull
    private Function<ProfileRequestContext, DuoOIDCIntegration> standardDuoIntegrationLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, DuoOIDCIntegration> passwordlessDuoIntegrationLookupStrategy = FunctionSupport.constant(null);
    @Nullable
    private BiFunction<HttpServletRequest, DynamicDuoOIDCIntegration, String> redirectURICreationStrategy;
    @Nonnull
    @NotEmpty
    private String ssoBypassFieldName = "donotcache";
    @NonnullAfterInit
    private DuoOIDCClientRegistry clientRegistry;

    public void setClientRegistry(@Nonnull DuoOIDCClientRegistry duoRegistry) {
        this.checkSetterPreconditions();
        this.clientRegistry = (DuoOIDCClientRegistry)Constraint.isNotNull((Object)duoRegistry, (String)"DuoClient registry can not be null");
    }

    public void setUsernameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.usernameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Username lookup strategy cannot be null");
    }

    public void setRedirectURICreationStrategy(@Nonnull BiFunction<HttpServletRequest, DynamicDuoOIDCIntegration, String> strategy) {
        this.checkSetterPreconditions();
        this.redirectURICreationStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"RedirectURI creation strategy cannot be null");
    }

    public void setPasswordlessContextLookupStrategy(@Nonnull Function<ProfileRequestContext, DuoPasswordlessContext> strategy) {
        this.checkSetterPreconditions();
        this.passwordlessContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"DuoPasswordlessContext lookup strategy cannot be null");
    }

    public void setStandardDuoIntegrationLookupStrategy(@Nonnull Function<ProfileRequestContext, DuoOIDCIntegration> strategy) {
        this.checkSetterPreconditions();
        this.standardDuoIntegrationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Standard DuoIntegration lookup strategy cannot be null");
    }

    public void setPasswordlessDuoIntegrationLookupStrategy(@Nonnull Function<ProfileRequestContext, DuoOIDCIntegration> strategy) {
        this.checkSetterPreconditions();
        this.passwordlessDuoIntegrationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Passwordless DuoIntegration lookup strategy cannot be null");
    }

    public void setSSOBypassFieldName(@Nonnull @NotEmpty String fieldName) {
        this.checkSetterPreconditions();
        this.ssoBypassFieldName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)fieldName), (String)"SSO Bypass field name cannot be null or empty.");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.clientRegistry == null) {
            throw new ComponentInitializationException("Duo Client Registry cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            this.log.warn("{} Profile action does not contain an HttpServletRequest", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        DuoOIDCAuthenticationContext duoContext = new DuoOIDCAuthenticationContext();
        authenticationContext.addSubcontext((BaseContext)duoContext, true);
        DuoPasswordlessContext passwordlessContext = this.passwordlessContextLookupStrategy.apply(profileRequestContext);
        if (passwordlessContext != null) {
            if (!this.doPasswordless(profileRequestContext, authenticationContext, duoContext, passwordlessContext)) {
                duoContext.removeFromParent();
                return;
            }
        } else if (!this.doStandard(profileRequestContext, duoContext)) {
            duoContext.removeFromParent();
            return;
        }
        DuoOIDCIntegration duoIntegration = duoContext.getIntegration();
        assert (duoIntegration != null);
        String nonce = DuoSupport.generateNonce(32);
        duoContext.setRequestState(nonce);
        try {
            this.computeAndStoreRedirectURIIfSupported(duoIntegration, request, duoContext);
            DuoOIDCClient client = this.clientRegistry.getClientOrCreate(duoIntegration);
            duoContext.setClient(client);
        }
        catch (DuoException e) {
            this.log.warn("{} Unable to establish a Duo Client for the given integration", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AuthenticationException");
            duoContext.removeFromParent();
            return;
        }
        this.log.debug("Created Duo authentication context for '{}'", (Object)duoContext.getUsername());
    }

    private boolean doPasswordless(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull DuoOIDCAuthenticationContext duoContext, @Nonnull DuoPasswordlessContext passwordlessContext) {
        String donotcache;
        if (passwordlessContext.getUsername() == null) {
            this.log.warn("{} No principal name available to initiate a Duo 2FA request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return false;
        }
        duoContext.setUsername(passwordlessContext.getUsername());
        DuoOIDCIntegration duoIntegration = this.passwordlessDuoIntegrationLookupStrategy.apply(profileRequestContext);
        if (duoIntegration == null) {
            this.log.warn("{} No DuoIntegration returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (!duoIntegration.isPasswordless()) {
            this.log.warn("{} DuoIntegration returned by lookup strategy was not passwordless", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        duoContext.setIntegration(duoIntegration);
        HttpServletRequest request = this.getHttpServletRequest();
        if (request != null && (donotcache = request.getParameter(this.ssoBypassFieldName)) != null && "1".equals(donotcache)) {
            this.log.debug("{} Recording do-not-cache instruction in authentication context", (Object)this.getLogPrefix());
            authenticationContext.setResultCacheable(false);
        }
        return true;
    }

    private boolean doStandard(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull DuoOIDCAuthenticationContext duoContext) {
        DuoOIDCIntegration duoIntegration = this.standardDuoIntegrationLookupStrategy.apply(profileRequestContext);
        if (duoIntegration == null) {
            this.log.warn("{} No DuoIntegration returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        duoContext.setIntegration(duoIntegration);
        String username = this.usernameLookupStrategy.apply(profileRequestContext);
        if (username == null) {
            this.log.warn("{} No principal name available to initiate a Duo 2FA request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return false;
        }
        duoContext.setUsername(username);
        return true;
    }

    private void computeAndStoreRedirectURIIfSupported(@Nonnull DuoOIDCIntegration duoIntegration, @Nonnull HttpServletRequest request, @Nonnull DuoOIDCAuthenticationContext context) throws DuoException {
        if (duoIntegration instanceof DynamicDuoOIDCIntegration) {
            DynamicDuoOIDCIntegration integration = (DynamicDuoOIDCIntegration)duoIntegration;
            if (this.redirectURICreationStrategy == null) {
                throw new DuoException("A dynamic DuoOIDC integration was supplied, but the redirect URI creation strategy was null. Please set a redirect URI creation strategy.");
            }
            assert (this.redirectURICreationStrategy != null);
            String redirectURI = this.redirectURICreationStrategy.apply(request, integration);
            if (redirectURI == null) {
                throw new DuoException("A redirect_uri was not registered or could not be computed");
            }
            integration.setRedirectURIIfAbsent(redirectURI);
            this.log.trace("{} Adding a dynamic redirect_uri '{}' to the context for the DuoClient to use if supported", (Object)this.getLogPrefix(), (Object)redirectURI);
            context.setRedirectURIOverride(redirectURI);
        }
    }
}

