/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.duo.DynamicDuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.URISupport;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafe
@Immutable
public final class DefaultRedirectURICreationStrategy
implements BiFunction<HttpServletRequest, DynamicDuoOIDCIntegration, String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultRedirectURICreationStrategy.class);
    @Nonnull
    @NotEmpty
    private final String callbackServletPath;

    public DefaultRedirectURICreationStrategy(@Nonnull @ParameterName(name="callbackPath") @NotEmpty String callbackPath) {
        this.callbackServletPath = (String)Constraint.isNotNull((Object)callbackPath, (String)"Duo Call back path can not be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable HttpServletRequest request, @Nullable DynamicDuoOIDCIntegration integration) {
        if (integration == null || request == null) {
            this.log.warn("Duo Integration or http request was null");
            return null;
        }
        String redirectFromIntegration = integration.getRegisteredRedirectURI();
        if (redirectFromIntegration != null) {
            this.log.trace("Using redirect_uri '{}' from the Duo integration settings", (Object)redirectFromIntegration);
            return redirectFromIntegration;
        }
        try {
            URI uri = URISupport.buildURIIgnoreDefaultPorts((String)request.getScheme(), (String)request.getServerName(), (int)request.getServerPort(), (String)(request.getContextPath() + request.getServletPath() + this.callbackServletPath));
            String origin = URISupport.buildOrigin((URI)uri);
            if (!integration.getAllowedOrigins().contains(origin)) {
                this.log.warn("The 'origin' of the computed redirect_uri ('{}') is not allowed. If permissible, add it to the allowed origins property.", (Object)origin);
                return null;
            }
            return uri.toString();
        }
        catch (URISyntaxException e) {
            this.log.warn("Unable to generate redirect_uri, {}", (Object)e.getMessage());
            return null;
        }
    }
}

