/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoClientInitializationException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClientFactory;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClientRegistry;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.DuoRegistryException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafe
public class DefaultDuoOIDCClientRegistry
extends AbstractIdentifiableInitializableComponent
implements DuoOIDCClientRegistry {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultDuoOIDCClientRegistry.class);
    @GuardedBy(value="this")
    @NonnullAfterInit
    private DuoOIDCClientFactory clientFactory;
    @Nonnull
    @NonnullElements
    private final ConcurrentMap<DuoOIDCIntegration, DuoOIDCClient> clientRegistry = new ConcurrentHashMap<DuoOIDCIntegration, DuoOIDCClient>(1);
    @Nonnull
    private final Function<DuoOIDCIntegration, DuoOIDCClient> clientRegistryMappingFunction = new CreateNewClientMappingFunction();

    public synchronized void setClientFactory(@Nonnull DuoOIDCClientFactory factory) {
        this.checkSetterPreconditions();
        this.clientFactory = (DuoOIDCClientFactory)Constraint.isNotNull((Object)factory, (String)"Duo client factory can not be null");
    }

    @NonnullAfterInit
    private synchronized DuoOIDCClientFactory getClientFactory() {
        return this.clientFactory;
    }

    @Nonnull
    public DuoOIDCClient getClientOrCreate(@Nonnull DuoOIDCIntegration integration) throws DuoRegistryException {
        Constraint.isNotNull((Object)integration, (String)"Duo integration can not be null");
        try {
            DuoOIDCClient client = this.clientRegistry.computeIfAbsent(integration, this.clientRegistryMappingFunction);
            this.log.trace("Duo registry returning the DuoClient instance '{}' of type '{}'", (Object)client.getClientId(), (Object)client.getClass().getCanonicalName());
            return client;
        }
        catch (DuoClientInitializationException e) {
            throw new DuoRegistryException("DuoClient could not be found or created in the registry", (Throwable)e);
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getClientFactory() == null) {
            throw new ComponentInitializationException("A Duo Client Factory must be configured and cannot be null");
        }
    }

    @ThreadSafe
    private class CreateNewClientMappingFunction
    implements Function<DuoOIDCIntegration, DuoOIDCClient> {
        @Nonnull
        private final Logger log = LoggerFactory.getLogger(CreateNewClientMappingFunction.class);

        private CreateNewClientMappingFunction() {
        }

        @Override
        @Nonnull
        public DuoOIDCClient apply(@Nullable DuoOIDCIntegration integration) {
            try {
                assert (integration != null);
                this.log.debug("Creating a new Duo client for integration '{}', using factory type '{}'", (Object)integration, (Object)DefaultDuoOIDCClientRegistry.this.getClientFactory().getClass().getTypeName());
                return DefaultDuoOIDCClientRegistry.this.getClientFactory().createInstance(integration);
            }
            catch (DuoClientException e) {
                throw new DuoClientInitializationException("Could not initialise the DuoClient for the integration with clientId " + integration.getClientId(), (Throwable)e);
            }
        }
    }
}

