/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.duo.DuoIntegration;
import net.shibboleth.idp.plugin.authn.duo.DuoAdminClient;
import net.shibboleth.idp.plugin.authn.duo.DuoAdminListMapResponseWrapper;
import net.shibboleth.idp.plugin.authn.duo.DuoAdminResponseWrapper;
import net.shibboleth.idp.plugin.authn.duo.DuoException;
import net.shibboleth.idp.plugin.authn.duo.impl.DuoSupport;
import net.shibboleth.idp.plugin.authn.duo.model.User;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.net.URIBuilder;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultDuoAdminClient
extends AbstractIdentifiableInitializableComponent
implements DuoAdminClient {
    private static final int DEFAULT_BACKOFF_FACTOR = 2;
    private static final int DEFAULT_INITIAL_BACKOFF_MS = 1000;
    private static final int DEFAULT_MAX_BACKOFF_MS = 16000;
    private static final int RATE_LIMIT_ERROR_CODE = 429;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultDuoAdminClient.class);
    private int backoffFactor = 2;
    private int initialBackoff = 1000;
    private int maxBackoff = 16000;
    @Nonnull
    private final Random random = new Random();
    @NonnullAfterInit
    private HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @Nonnull
    private Function<ProfileRequestContext, DuoIntegration> adminDuoIntegrationLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    @NotEmpty
    private String usersAdminEndpoint = "/admin/v1/users";

    public void setBackoffFactor(int factor) {
        this.checkSetterPreconditions();
        this.backoffFactor = factor;
    }

    public void setInitialBackoff(int backoff) {
        this.checkSetterPreconditions();
        this.initialBackoff = backoff;
    }

    public void setMaxBackoff(int backoff) {
        this.checkSetterPreconditions();
        this.maxBackoff = backoff;
    }

    public void setHttpClient(@Nonnull HttpClient client) {
        this.checkSetterPreconditions();
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HTTP client cannot be null");
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.checkSetterPreconditions();
        this.httpClientSecurityParameters = params;
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    public void setAdminDuoIntegrationLookupStrategy(@Nonnull Function<ProfileRequestContext, DuoIntegration> strategy) {
        this.checkSetterPreconditions();
        this.adminDuoIntegrationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AdminDuoIntegrationLookup strategy can not be null");
    }

    public void setUsersAdminEndpoint(@Nonnull @NotEmpty String endpoint) {
        this.checkSetterPreconditions();
        this.usersAdminEndpoint = Constraint.isNotEmpty((String)endpoint, (String)"UserAdminEndpoint can not be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpClient == null) {
            throw new ComponentInitializationException("HttpClient cannot be null");
        }
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("ObjectMapper cannot be null");
        }
    }

    @Nullable
    public User getUser(@Nonnull ProfileRequestContext context, @Nonnull String username) throws DuoException {
        try {
            ClassicHttpRequest request = this.buildRequest(context, this.usersAdminEndpoint, Map.of("username", username));
            List response = (List)this.doAPIRequest(request, new TypeReference<DuoAdminResponseWrapper<List<User>>>(){}, this.initialBackoff).getResponse();
            if (response.isEmpty()) {
                return null;
            }
            if (response.size() > 1) {
                throw new DuoException("User API response contained more than one record");
            }
            return (User)response.get(0);
        }
        catch (Exception ex) {
            throw new DuoException("Unable to to get User '" + username + "' from Duo's Admin API", (Throwable)ex);
        }
    }

    @Nonnull
    public <T extends DuoAdminResponseWrapper<?>> T retrieve(@Nonnull ProfileRequestContext context, @Nonnull @NotEmpty String path, @Nullable @NonnullElements Map<String, String> parameters, @Nonnull TypeReference<T> wrapperTypeRef) throws DuoException {
        try {
            ClassicHttpRequest request = this.buildRequest(context, path, parameters);
            return this.doAPIRequest(request, wrapperTypeRef, this.initialBackoff);
        }
        catch (IOException | DuoException e) {
            throw new DuoException(e);
        }
    }

    @Nonnull
    public DuoAdminListMapResponseWrapper retrieve(@Nonnull ProfileRequestContext context, @Nonnull @NotEmpty String path, @Nullable @NonnullElements Map<String, String> parameters) throws DuoException {
        try {
            ClassicHttpRequest request = this.buildRequest(context, path, parameters);
            return this.doAPIRequest(request, new TypeReference<DuoAdminListMapResponseWrapper>(){}, this.initialBackoff);
        }
        catch (IOException | DuoException e) {
            throw new DuoException(e);
        }
    }

    @Nonnull
    private DuoIntegration getIntegrationAndCheckComponentActive(@Nonnull ProfileRequestContext prc) throws DuoException {
        this.checkComponentActive();
        DuoIntegration integration = this.adminDuoIntegrationLookupStrategy.apply(prc);
        if (integration == null) {
            throw new DuoException("Unable to locate Duo Integration.");
        }
        return integration;
    }

    @Nonnull
    private ClassicHttpRequest buildRequest(@Nonnull ProfileRequestContext context, @Nonnull @NotEmpty String path, @Nullable @NonnullElements Map<String, String> parameters) throws DuoException {
        DuoIntegration integration = this.getIntegrationAndCheckComponentActive(context);
        try {
            URI uri = new URIBuilder().setScheme("https").setHost(integration.getAPIHost()).setPath(path).build();
            ClassicRequestBuilder rb = ClassicRequestBuilder.get().setUri(uri);
            if (parameters != null) {
                parameters.forEach((arg_0, arg_1) -> ((ClassicRequestBuilder)rb).addParameter(arg_0, arg_1));
            }
            assert (rb != null);
            DuoSupport.signRequest(rb, integration);
            ClassicHttpRequest request = rb.build();
            assert (request != null);
            return request;
        }
        catch (URISyntaxException | InvalidKeyException | NoSuchAlgorithmException | EncodingException ex) {
            throw new DuoException("Unable to to get response from Duo Admin API", ex);
        }
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    private <T extends DuoAdminResponseWrapper<?>> T doAPIRequest(@Nonnull ClassicHttpRequest request, @Nonnull TypeReference<T> wrapperTypeRef, int backoff) throws DuoException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

