/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.duo.PasswordlessCookieManager;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ClearPasswordlessCookie
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ClearPasswordlessCookie.class);
    @NonnullAfterInit
    private PasswordlessCookieManager cookieManager;

    public void setCookieManager(@Nullable PasswordlessCookieManager manager) {
        this.checkSetterPreconditions();
        this.cookieManager = (PasswordlessCookieManager)Constraint.isNotNull((Object)manager, (String)"PasswordlessCookieManager cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.cookieManager == null) {
            throw new ComponentInitializationException("PasswordlessCookieManager cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Clearing passwordless guard cookie at user instruction", (Object)this.getLogPrefix());
        this.cookieManager.clearCookie();
    }
}

