/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.duo.model.DuoHealthCheckResponse;
import net.shibboleth.shared.annotation.constraint.NotEmpty;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
@ThreadSafe
public final class DuoHealthCheck {
    @Nonnull
    @NotEmpty
    private final String status;
    @Nullable
    private final DuoHealthCheckResponse response;
    @Nullable
    @NotEmpty
    private final String code;
    @Nullable
    private final String timestamp;
    @Nullable
    private final String message;
    @Nullable
    private final String messageDetail;

    private DuoHealthCheck(Builder builder) {
        this.status = builder.status;
        this.response = builder.response;
        this.code = builder.code;
        this.timestamp = builder.timestamp;
        this.message = builder.message;
        this.messageDetail = builder.messageDetail;
    }

    @Nonnull
    public String getStatus() {
        return this.status;
    }

    @Nullable
    public DuoHealthCheckResponse getResponse() {
        return this.response;
    }

    @Nullable
    public String getCode() {
        return this.code;
    }

    @Nullable
    public String getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public String getMessageDetail() {
        return this.messageDetail;
    }

    public String toString() {
        return String.format("DuoHealthCheck [status=%s, response=%s, code=%s, timestamp=%s, message=%s, messageDetail=%s]", this.status, this.response, this.code, this.timestamp, this.message, this.messageDetail);
    }

    public static IStatusStage builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IStatusStage,
    IBuildStage {
        private String status;
        private DuoHealthCheckResponse response;
        private String code;
        private String timestamp;
        private String message;
        private String messageDetail;

        private Builder() {
        }

        @Override
        @JsonProperty(value="stat")
        public IBuildStage withStatus(String stat) {
            this.status = stat;
            return this;
        }

        @Override
        @JsonProperty(value="response")
        public IBuildStage withResponse(DuoHealthCheckResponse resp) {
            this.response = resp;
            return this;
        }

        @Override
        @JsonProperty(value="code")
        public IBuildStage withCode(String codeIn) {
            this.code = codeIn;
            return this;
        }

        @Override
        @JsonProperty(value="timestamp")
        public IBuildStage withTimestamp(String timestampIn) {
            this.timestamp = timestampIn;
            return this;
        }

        @Override
        @JsonProperty(value="message")
        public IBuildStage withMessage(String msg) {
            this.message = msg;
            return this;
        }

        @Override
        @JsonProperty(value="message_detail")
        public IBuildStage withMessageDetail(String msgDetail) {
            this.messageDetail = msgDetail;
            return this;
        }

        @Override
        public DuoHealthCheck build() {
            return new DuoHealthCheck(this);
        }
    }

    public static interface IBuildStage {
        public IBuildStage withResponse(DuoHealthCheckResponse var1);

        public IBuildStage withCode(String var1);

        public IBuildStage withTimestamp(String var1);

        public IBuildStage withMessage(String var1);

        public IBuildStage withMessageDetail(String var1);

        public DuoHealthCheck build();
    }

    public static interface IStatusStage {
        public IBuildStage withStatus(String var1);
    }
}

