/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.duo;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.principal.CloneablePrincipal;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public class DuoFactorPrincipal
implements CloneablePrincipal {
    @Nonnull
    @NotEmpty
    private String factor;

    public DuoFactorPrincipal(@Nonnull @ParameterName(name="factor") @NotEmpty String duoFactor) {
        this.factor = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)duoFactor), (String)"DuoFactor cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getName() {
        return this.factor;
    }

    public int hashCode() {
        return this.factor.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof DuoFactorPrincipal) {
            DuoFactorPrincipal principalOther = (DuoFactorPrincipal)other;
            return this.factor.equals(principalOther.getName());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("factor", (Object)this.factor).toString();
    }

    @Nonnull
    public DuoFactorPrincipal clone() throws CloneNotSupportedException {
        DuoFactorPrincipal copy = (DuoFactorPrincipal)super.clone();
        copy.factor = this.factor;
        return copy;
    }
}

