/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.nimbus.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class TokenResponse {
    @Nonnull
    private final String idToken;
    @Nonnull
    private final String accessToken;
    @Nullable
    private final String refreshToken;
    @Nonnull
    private final String tokenType;
    @Nullable
    private final Integer expiresIn;
    @Nullable
    private final String scope;

    private TokenResponse(Builder builder) {
        this.idToken = builder.idToken;
        this.accessToken = builder.accessToken;
        this.tokenType = builder.tokenType;
        this.refreshToken = builder.refreshToken;
        this.expiresIn = builder.expiresIn;
        this.scope = builder.scope;
    }

    public final String getIdToken() {
        return this.idToken;
    }

    public final String getAccessToken() {
        return this.accessToken;
    }

    public final String getRefreshToken() {
        return this.refreshToken;
    }

    public final String getTokenType() {
        return this.tokenType;
    }

    public final Integer getExpiresIn() {
        return this.expiresIn;
    }

    public final String getScope() {
        return this.scope;
    }

    public String toString() {
        return "TokenResponse [idToken=" + this.idToken + ", accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ", tokenType=" + this.tokenType + ", expiresIn=" + this.expiresIn + ", scope=" + this.scope + "]";
    }

    public static IIdTokenStage builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IIdTokenStage,
    IAccessTokenStage,
    ITokenTypeStage,
    IBuildStage {
        private String idToken;
        private String accessToken;
        private String tokenType;
        private String refreshToken;
        private Integer expiresIn;
        private String scope;

        private Builder() {
        }

        @Override
        @JsonProperty(value="id_token")
        public IAccessTokenStage withIdToken(String token) {
            this.idToken = token;
            return this;
        }

        @Override
        @JsonProperty(value="access_token")
        public ITokenTypeStage withAccessToken(String accessTokenIn) {
            this.accessToken = accessTokenIn;
            return this;
        }

        @Override
        @JsonProperty(value="token_type")
        public IBuildStage withTokenType(String type) {
            this.tokenType = type;
            return this;
        }

        @Override
        @JsonProperty(value="refresh_token")
        public IBuildStage withRefreshToken(String refresh) {
            this.refreshToken = refresh;
            return this;
        }

        @Override
        @JsonProperty(value="expires_in")
        public IBuildStage withExpiresIn(Integer expires) {
            this.expiresIn = expires;
            return this;
        }

        @Override
        @JsonProperty(value="scope")
        public IBuildStage withScope(String scopeIn) {
            this.scope = scopeIn;
            return this;
        }

        @Override
        public TokenResponse build() {
            return new TokenResponse(this);
        }
    }

    public static interface IBuildStage {
        public IBuildStage withRefreshToken(String var1);

        public IBuildStage withExpiresIn(Integer var1);

        public IBuildStage withScope(String var1);

        public TokenResponse build();
    }

    public static interface ITokenTypeStage {
        public IBuildStage withTokenType(String var1);
    }

    public static interface IAccessTokenStage {
        public ITokenTypeStage withAccessToken(String var1);
    }

    public static interface IIdTokenStage {
        public IAccessTokenStage withIdToken(String var1);
    }
}

