/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.jetty94;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class DelegateToApplicationSslContextFactory
extends SslContextFactory.Server {
    private boolean advertiseIssuers;

    public DelegateToApplicationSslContextFactory() {
        this.setWantClientAuth(true);
        this.setValidateCerts(false);
    }

    public void setAdvertiseIssuers(boolean flag) {
        this.advertiseIssuers = flag;
    }

    protected TrustManager[] getTrustManagers(final KeyStore trustStore, Collection<? extends CRL> crls) throws Exception {
        X509TrustManager noTrustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String auth) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String auth) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                if (!DelegateToApplicationSslContextFactory.this.advertiseIssuers || trustStore == null) {
                    return new X509Certificate[0];
                }
                ArrayList<X509Certificate> issuers = new ArrayList<X509Certificate>();
                try {
                    Enumeration<String> aliases = trustStore.aliases();
                    while (aliases.hasMoreElements()) {
                        Certificate cert;
                        String alias = aliases.nextElement();
                        if (!trustStore.isCertificateEntry(alias) || !((cert = trustStore.getCertificate(alias)) instanceof X509Certificate)) continue;
                        issuers.add((X509Certificate)cert);
                    }
                }
                catch (KeyStoreException e) {
                    Log.getLogger(DelegateToApplicationSslContextFactory.class).warn((Throwable)e);
                }
                return issuers.toArray(new X509Certificate[issuers.size()]);
            }
        };
        return new TrustManager[]{noTrustManager};
    }
}

