/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.saml.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeSupport;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.attribute.resolver.dc.saml.impl.SAMLDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.saml.util.impl.AttributeAuthorityEntityIDContext;
import net.shibboleth.idp.attribute.resolver.dc.saml.util.impl.AttributeAuthorityEntityIDReference;
import net.shibboleth.idp.attribute.resolver.dc.saml.util.impl.AttributeAuthorityEntityIDSource;
import net.shibboleth.idp.attribute.resolver.dc.saml.util.impl.AttributeAuthorityEntityIDValue;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.messaging.context.BaseContext;
import org.slf4j.Logger;

public class SimpleAggregationSAMLDataConnector
extends AbstractDataConnector {
    private Logger log = LoggerFactory.getLogger(SimpleAggregationSAMLDataConnector.class);
    @NonnullAfterInit
    private SAMLDataConnector queryConnector;
    @Nonnull
    private List<AttributeAuthorityEntityIDSource> entityIDSources = CollectionSupport.emptyList();

    public SAMLDataConnector getQueryConnector() {
        return this.queryConnector;
    }

    public void setQueryConnector(@Nullable SAMLDataConnector connector) {
        this.checkSetterPreconditions();
        this.queryConnector = connector;
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<AttributeAuthorityEntityIDSource> getEntityIDSources() {
        return this.entityIDSources;
    }

    public void setEntityIDSources(@Nullable List<AttributeAuthorityEntityIDSource> sources) {
        this.checkSetterPreconditions();
        this.entityIDSources = sources == null ? CollectionSupport.emptyList() : (List)((NonnullSupplier)sources.stream().filter(Objects::nonNull).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getQueryConnector() == null) {
            throw new ComponentInitializationException("Query connector was null");
        }
        if (this.getEntityIDSources().isEmpty()) {
            throw new ComponentInitializationException("EntityID sources list was empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        this.checkComponentActive();
        LinkedList results = new LinkedList();
        List<String> authtorityEntityIDs = this.resolveAuthorityEntityIDs(resolutionContext, workContext);
        this.log.trace("{} Resolved {} attribute authority entityIDs: {}", new Object[]{this.getLogPrefix(), authtorityEntityIDs.size(), authtorityEntityIDs});
        for (String authorityEntityID : authtorityEntityIDs) {
            assert (authorityEntityID != null);
            try {
                this.log.debug("Executing SAML attribute query against authority entityID: {}", (Object)authorityEntityID);
                resolutionContext.addSubcontext((BaseContext)new AttributeAuthorityEntityIDContext(authorityEntityID), true);
                Map authorityResults = (Map)this.getQueryConnector().resolve(resolutionContext);
                if (authorityResults != null) {
                    this.log.debug("{} Authority returned {} unique attributes", (Object)this.getLogPrefix(), (Object)authorityResults.keySet().size());
                    results.addAll(authorityResults.values());
                    continue;
                }
                this.log.debug("{} Authority returned no attributes", (Object)this.getLogPrefix());
            }
            catch (Exception e) {
                this.log.warn("{} Fatal error executing SAML 2 attribute query against authority: {}", (Object)this.getLogPrefix(), (Object)authorityEntityID);
            }
            finally {
                resolutionContext.removeSubcontext(AttributeAuthorityEntityIDContext.class);
            }
        }
        Map mergedResults = IdPAttributeSupport.toMapMergeDuplicates(results);
        if (this.log.isTraceEnabled()) {
            this.log.trace("{} Decoded {} total unique aggregated attribute IDs from all attribute authorities:", (Object)this.getLogPrefix(), (Object)mergedResults.keySet().size());
            for (String attributeID : mergedResults.keySet().stream().sorted().toList()) {
                this.log.trace("\tAttribute ID '{}', # of values: {}", (Object)attributeID, (Object)((IdPAttribute)mergedResults.get(attributeID)).getValues().size());
            }
        }
        return mergedResults;
    }

    @Nonnull
    protected List<String> resolveAuthorityEntityIDs(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) {
        ArrayList<String> entityIDs = new ArrayList<String>();
        Map dependencyAttributes = null;
        for (AttributeAuthorityEntityIDSource source : this.getEntityIDSources()) {
            if (source instanceof AttributeAuthorityEntityIDValue) {
                entityIDs.add(source.getValue());
                continue;
            }
            if (source instanceof AttributeAuthorityEntityIDReference) {
                String reference = source.getValue();
                if (dependencyAttributes == null) {
                    dependencyAttributes = PluginDependencySupport.getAllAttributeValues((AttributeResolverWorkContext)workContext, (Collection)this.getAttributeDependencies(), (Collection)this.getDataConnectorDependencies());
                }
                if (!dependencyAttributes.containsKey(reference)) continue;
                entityIDs.addAll(((List)dependencyAttributes.get(reference)).stream().filter(StringAttributeValue.class::isInstance).map(StringAttributeValue.class::cast).map(StringAttributeValue::getValue).toList());
                continue;
            }
            this.log.warn("{} Saw AttributeAuthorityEntityIDSource of unsupported type, could not process: {}", (Object)this.getLogPrefix(), (Object)source.getClass().getName());
        }
        return (List)((NonnullSupplier)entityIDs.stream().distinct().collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get();
    }
}

