/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.saml.impl;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.dc.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.idp.attribute.resolver.dc.impl.AbstractSearchDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.saml.ExecutableQuery;
import net.shibboleth.idp.attribute.resolver.dc.saml.ResponseData;
import net.shibboleth.idp.attribute.resolver.dc.saml.ResponseMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.saml.util.impl.AssertionValidationProcessor;
import net.shibboleth.idp.attribute.resolver.dc.saml.util.impl.DecryptionProcessor;
import net.shibboleth.idp.attribute.resolver.dc.saml.util.impl.SubjectMatchProcessor;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.security.SecurityException;
import org.opensaml.soap.client.SOAPClient;
import org.opensaml.soap.common.SOAPException;
import org.slf4j.Logger;

public class SAMLDataConnector
extends AbstractSearchDataConnector<ExecutableQuery, ResponseMappingStrategy> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAMLDataConnector.class);
    @NonnullAfterInit
    private SOAPClient soapClient;
    @NonnullAfterInit
    private DecryptionProcessor decryptionProcessor;
    @NonnullAfterInit
    private AssertionValidationProcessor assertionValidationProcessor;
    @NonnullAfterInit
    private SubjectMatchProcessor subjectMatchProcessor;
    private boolean subjectMatch;

    public SAMLDataConnector() {
        this.setValidator(new NullValidator());
    }

    @NonnullAfterInit
    public SOAPClient getSOAPClient() {
        return this.soapClient;
    }

    public void setSOAPClient(@Nullable SOAPClient client) {
        this.checkSetterPreconditions();
        this.soapClient = client;
    }

    @NonnullAfterInit
    public DecryptionProcessor getDecryptionProcessor() {
        return this.decryptionProcessor;
    }

    public void setDecryptionProcessor(@Nullable DecryptionProcessor processor) {
        this.checkSetterPreconditions();
        this.decryptionProcessor = processor;
    }

    @NonnullAfterInit
    public AssertionValidationProcessor getAssertionValidationProcessor() {
        return this.assertionValidationProcessor;
    }

    public void setAssertionValidationProcessor(@Nullable AssertionValidationProcessor processor) {
        this.checkSetterPreconditions();
        this.assertionValidationProcessor = processor;
    }

    @NonnullAfterInit
    public SubjectMatchProcessor getSubjectMatchProcessor() {
        return this.subjectMatchProcessor;
    }

    public void setSubjectMatchProcessor(@Nullable SubjectMatchProcessor processor) {
        this.checkSetterPreconditions();
        this.subjectMatchProcessor = processor;
    }

    public boolean isSubjectMatch() {
        return this.subjectMatch;
    }

    public void setSubjectMatch(boolean flag) {
        this.checkSetterPreconditions();
        this.subjectMatch = flag;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getSOAPClient() == null) {
            throw new ComponentInitializationException("SOAPClient was null");
        }
        if (this.getDecryptionProcessor() == null) {
            throw new ComponentInitializationException("DecryptionProcessor was null");
        }
        if (this.getAssertionValidationProcessor() == null) {
            throw new ComponentInitializationException("AssertionValidationProcessor was null");
        }
        if (this.getSubjectMatchProcessor() == null) {
            throw new ComponentInitializationException("SubjectMatchProcessor was null");
        }
    }

    @Override
    @Nullable
    protected Map<String, IdPAttribute> retrieveAttributes(@Nonnull ExecutableQuery executable) throws ResolutionException {
        try {
            ResponseMappingStrategy strategy = (ResponseMappingStrategy)this.getMappingStrategy();
            SOAPClient localClient = this.getSOAPClient();
            assert (strategy != null && localClient != null);
            ResponseData responseData = executable.execute(localClient);
            this.processResponse(responseData);
            Map attributes = strategy.map((Object)responseData);
            return attributes;
        }
        catch (SAMLException | SecurityException | SOAPException e) {
            throw new ResolutionException(this.getLogPrefix() + " SAML AttributeQuery failed", (Exception)e);
        }
    }

    protected void processResponse(@Nonnull ResponseData responseData) throws ResolutionException {
        Response response = responseData.getResponse();
        DecryptionProcessor decryptionProcessor = this.getDecryptionProcessor();
        Decrypter decrypter = null;
        if (decryptionProcessor.haveEncryptedAssertions(response)) {
            decrypter = decryptionProcessor.buildDecrypter(responseData);
            decryptionProcessor.decryptAssertions(response, decrypter);
        }
        this.getAssertionValidationProcessor().validateAssertions(response, responseData.getSOAPClientContext());
        if (response.getAssertions().isEmpty()) {
            this.log.warn("{} SAML Response contained no valid Assertions", (Object)this.getLogPrefix());
            throw new ResolutionException("SAML Response contained no valid Assertions");
        }
        if (decryptionProcessor.haveEncryptedContent(response)) {
            if (decrypter == null) {
                decrypter = decryptionProcessor.buildDecrypter(responseData);
            }
            decryptionProcessor.decryptAssertionContent(response, decrypter);
        }
        if (!this.isSubjectMatch()) {
            this.log.debug("Subject match is disabled, skipping");
            return;
        }
        this.getSubjectMatchProcessor().process(responseData);
    }

    private final class NullValidator
    implements Validator {
        private boolean throwValidateError;

        private NullValidator() {
        }

        public void validate(@Nonnull DataConnector dataConnector) throws ValidationException {
        }

        public void setThrowValidateError(boolean what) {
            this.throwValidateError = what;
        }

        public boolean isThrowValidateError() {
            return this.throwValidateError;
        }
    }
}

