/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ad.impl.ScriptedIdPAttributeImpl;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.attribute.resolver.scripted.ResolverScriptContextExtender;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.scripting.AbstractScriptEvaluator;
import net.shibboleth.shared.scripting.EvaluableScript;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

@ThreadSafe
public class ScriptedAttributeDefinition
extends AbstractAttributeDefinition {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedAttributeDefinition.class);
    @NonnullAfterInit
    private EvaluableScript script;
    @NonnullAfterInit
    private AttributeDefinitionScriptEvaluator scriptEvaluator;
    @Nonnull
    private Collection<ResolverScriptContextExtender> contextExtenders = CollectionSupport.emptyList();
    @Nullable
    private Object customObject;

    @Nullable
    public Object getCustomObject() {
        return this.customObject;
    }

    public void setCustomObject(@Nullable Object object) {
        this.checkSetterPreconditions();
        this.customObject = object;
    }

    @NonnullAfterInit
    public EvaluableScript getScript() {
        return this.script;
    }

    public void setScript(@Nonnull EvaluableScript definitionScript) {
        this.checkSetterPreconditions();
        this.script = (EvaluableScript)Constraint.isNotNull((Object)definitionScript, (String)"Attribute definition script cannot be null");
    }

    public void setScriptContextExtenders(@Nullable Collection<ResolverScriptContextExtender> extenders) {
        this.checkSetterPreconditions();
        this.contextExtenders = extenders != null ? CollectionSupport.copyToList(extenders) : CollectionSupport.emptyList();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.script) {
            throw new ComponentInitializationException(this.getLogPrefix() + " no script was configured");
        }
        assert (this.script != null);
        this.scriptEvaluator = new AttributeDefinitionScriptEvaluator(this.script);
        this.scriptEvaluator.setCustomObject(this.customObject);
        this.scriptEvaluator.setContextExtenders(this.contextExtenders);
        this.scriptEvaluator.setLogPrefix(this.getLogPrefix());
    }

    @Nullable
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        Constraint.isNotNull((Object)resolutionContext, (String)"AttributeResolutionContext cannot be null");
        Constraint.isNotNull((Object)workContext, (String)"AttributeResolverWorkContext cannot be null");
        return this.scriptEvaluator.execute(resolutionContext, workContext);
    }

    private class AttributeDefinitionScriptEvaluator
    extends AbstractScriptEvaluator {
        public AttributeDefinitionScriptEvaluator(EvaluableScript theScript) {
            super(theScript);
        }

        @Nullable
        protected IdPAttribute execute(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
            try {
                return (IdPAttribute)this.evaluate(new Object[]{resolutionContext, workContext});
            }
            catch (RuntimeException e) {
                throw new ResolutionException(this.getLogPrefix() + "Script did not run successfully", (Exception)e);
            }
        }

        protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
            if (input == null || !(input[1] instanceof AttributeResolverWorkContext)) {
                ScriptedAttributeDefinition.this.log.error("{} AttributeResolverWorkContext missing from script context inputs", (Object)this.getLogPrefix());
                return;
            }
            AttributeResolverWorkContext input1 = (AttributeResolverWorkContext)input[1];
            assert (input1 != null);
            Map dependencyAttributes = PluginDependencySupport.getAllAttributeValues((AttributeResolverWorkContext)input1, (Collection)ScriptedAttributeDefinition.this.getAttributeDependencies(), (Collection)ScriptedAttributeDefinition.this.getDataConnectorDependencies());
            if (dependencyAttributes.containsKey(ScriptedAttributeDefinition.this.ensureId())) {
                ScriptedAttributeDefinition.this.log.debug("{} The attribute ID to be populated is a dependency, not created", (Object)this.getLogPrefix());
            } else {
                ScriptedAttributeDefinition.this.log.debug("{} Adding to-be-populated attribute to script context", (Object)this.getLogPrefix());
                IdPAttribute newAttribute = new IdPAttribute(ScriptedAttributeDefinition.this.ensureId());
                scriptContext.setAttribute(ScriptedAttributeDefinition.this.ensureId(), new ScriptedIdPAttributeImpl(newAttribute, this.getLogPrefix()), 100);
            }
            ScriptedAttributeDefinition.this.log.debug("{} Adding contexts to script context", (Object)this.getLogPrefix());
            scriptContext.setAttribute("resolutionContext", input[0], 100);
            ProfileRequestContext prc = (ProfileRequestContext)((AttributeResolutionContext)input[0]).getProfileRequestContextLookupStrategy().apply((AttributeResolutionContext)input[0]);
            if (null == prc) {
                ScriptedAttributeDefinition.this.log.error("{} ProfileRequestContext could not be located", (Object)this.getLogPrefix());
            }
            scriptContext.setAttribute("profileContext", prc, 100);
            for (Map.Entry dependencyAttribute : dependencyAttributes.entrySet()) {
                ScriptedAttributeDefinition.this.log.trace("{} Adding dependent attribute '{}' with the following values to the script context: {}", new Object[]{this.getLogPrefix(), dependencyAttribute.getKey(), dependencyAttribute.getValue()});
                String key = (String)dependencyAttribute.getKey();
                assert (key != null);
                IdPAttribute pseudoAttribute = new IdPAttribute(key);
                pseudoAttribute.setValues((List)dependencyAttribute.getValue());
                scriptContext.setAttribute((String)dependencyAttribute.getKey(), new ScriptedIdPAttributeImpl(pseudoAttribute, this.getLogPrefix()), 100);
            }
        }

        @Nullable
        protected Object finalizeContext(@Nonnull ScriptContext scriptContext, @Nullable Object scriptResult) throws ScriptException {
            Object result = scriptContext.getAttribute(ScriptedAttributeDefinition.this.ensureId());
            if (null == result) {
                ScriptedAttributeDefinition.this.log.info("{} No value returned", (Object)this.getLogPrefix());
                return null;
            }
            if (result instanceof ScriptedIdPAttributeImpl) {
                ScriptedIdPAttributeImpl scriptedAttribute = (ScriptedIdPAttributeImpl)result;
                try {
                    return scriptedAttribute.getResultingAttribute();
                }
                catch (ResolutionException e) {
                    throw new ScriptException((Exception)((Object)e));
                }
            }
            throw new ScriptException(this.getLogPrefix() + " returned variable was of wrong type (" + result.getClass().toString() + ")");
        }
    }
}

