/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.UnsupportedAttributeTypeException;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolvedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ResolverAttributeDefinitionDependency;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

@ThreadSafe
public class ScopedAttributeDefinition
extends AbstractAttributeDefinition {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScopedAttributeDefinition.class);
    @Nullable
    private String scope;
    @Nullable
    private String scopeSource;
    @NonnullAfterInit
    private Collection<ResolverAttributeDefinitionDependency> nonScopeAttributeDependencies;

    @Nullable
    public String getScope() {
        return this.scope;
    }

    public void setScope(@Nonnull @NotEmpty String newScope) {
        this.checkSetterPreconditions();
        this.scope = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)newScope), (String)"Scope can not be null or empty");
    }

    @Nullable
    public String getScopeSource() {
        return this.scopeSource;
    }

    @Nonnull
    private Collection<ResolverAttributeDefinitionDependency> ensureNonScopeAttributeDependencies() {
        this.checkComponentActive();
        assert (this.nonScopeAttributeDependencies != null);
        return this.nonScopeAttributeDependencies;
    }

    public void setScopeSource(@Nonnull @NotEmpty String attributeId) {
        this.checkSetterPreconditions();
        this.scopeSource = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)attributeId), (String)"ScopeSource can not be null or empty");
    }

    @Nonnull
    @NotEmpty
    private String getScopeFromSource(@Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        ResolvedAttributeDefinition resolved = (ResolvedAttributeDefinition)workContext.getResolvedIdPAttributeDefinitions().get(this.getScopeSource());
        if (resolved == null) {
            this.log.error("{} Scope source '{}' not found in resolved dependencies", (Object)this.getLogPrefix(), (Object)this.getScopeSource());
            this.log.debug("{} Attributes available {}", (Object)this.getLogPrefix(), workContext.getResolvedIdPAttributeDefinitions().entrySet());
            throw new ResolutionException("Scope source not found in resolved dependencies");
        }
        IdPAttribute scopeAttribute = resolved.getResolvedAttribute();
        if (scopeAttribute == null) {
            this.log.error("{} Scope source '{}' not found in resolved dependencies", (Object)this.getLogPrefix(), (Object)this.getScopeSource());
            this.log.debug("{} Attributes available {}", (Object)this.getLogPrefix(), workContext.getResolvedIdPAttributeDefinitions().entrySet());
            throw new ResolutionException("Scope source not found in resolved dependencies");
        }
        List values = scopeAttribute.getValues();
        if (values.size() != 1) {
            this.log.error("{} Exactly one value required for {}, {} found", new Object[]{this.getLogPrefix(), this.getScopeSource(), values.size()});
            this.log.debug("{} Values returned {}", (Object)this.getLogPrefix(), (Object)values);
            throw new ResolutionException("Exactly one value for scope source required");
        }
        IdPAttributeValue value = (IdPAttributeValue)values.get(0);
        if (value instanceof StringAttributeValue && !(value instanceof ScopedStringAttributeValue)) {
            return ((StringAttributeValue)value).getValue();
        }
        this.log.error("{} Attribute {} must return a StringAttributeValue returned a {}", new Object[]{this.getLogPrefix(), this.getScopeSource(), value.getClass()});
        throw new ResolutionException("SourceAttribute must only return a StringAttributeValue");
    }

    @Nonnull
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        this.checkComponentActive();
        IdPAttribute resultantAttribute = new IdPAttribute(this.ensureId());
        String scopeValue = this.scopeSource == null ? this.scope : this.getScopeFromSource(workContext);
        if (scopeValue == null) {
            throw new ResolutionException(this.getLogPrefix() + " Scope was null or empty");
        }
        List dependencyValues = PluginDependencySupport.getMergedAttributeValues((AttributeResolverWorkContext)workContext, this.ensureNonScopeAttributeDependencies(), (Collection)this.getDataConnectorDependencies(), (String)this.ensureId());
        ArrayList<ScopedStringAttributeValue> valueList = new ArrayList<ScopedStringAttributeValue>(dependencyValues.size());
        for (IdPAttributeValue dependencyValue : dependencyValues) {
            if (dependencyValue instanceof EmptyAttributeValue) {
                EmptyAttributeValue emptyVal = (EmptyAttributeValue)dependencyValue;
                this.log.debug("{} ignored empty value of type {}", (Object)this.getLogPrefix(), (Object)emptyVal.getDisplayValue());
                continue;
            }
            if (!(dependencyValue instanceof StringAttributeValue)) {
                throw new ResolutionException((Exception)new UnsupportedAttributeTypeException(this.getLogPrefix() + "This attribute definition only supports attribute value types of " + StringAttributeValue.class.getName() + " not values of type " + dependencyValue.getClass().getName()));
            }
            valueList.add(new ScopedStringAttributeValue(((StringAttributeValue)dependencyValue).getValue(), scopeValue));
        }
        resultantAttribute.setValues(valueList);
        return resultantAttribute;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.scope != null) {
            if (this.scopeSource != null) {
                throw new ComponentInitializationException(this.getLogPrefix() + "': cannot specify scope and scopeSource");
            }
            this.nonScopeAttributeDependencies = this.getAttributeDependencies();
        } else if (this.scopeSource != null) {
            ResolverAttributeDefinitionDependency source = new ResolverAttributeDefinitionDependency(this.scopeSource);
            HashSet<ResolverAttributeDefinitionDependency> nonScope = new HashSet<ResolverAttributeDefinitionDependency>(this.getAttributeDependencies());
            if (!nonScope.remove(source)) {
                throw new ComponentInitializationException(this.getLogPrefix() + "': AttributeDependencies did not contain scope source '" + this.scopeSource + "'");
            }
            this.nonScopeAttributeDependencies = nonScope;
        } else {
            throw new ComponentInitializationException(this.getLogPrefix() + "': neither scope now scopeSource configured");
        }
        if (this.getDataConnectorDependencies().isEmpty() && this.nonScopeAttributeDependencies.isEmpty()) {
            throw new ComponentInitializationException(this.getLogPrefix() + "': no actual dependencies were configured");
        }
    }
}

