/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ContextDerivedAttributeDefinition
extends AbstractAttributeDefinition {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ContextDerivedAttributeDefinition.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, List<IdPAttributeValue>> attributeValuesFunction;

    public void setAttributeValuesFunction(@Nonnull Function<ProfileRequestContext, List<IdPAttributeValue>> function) {
        this.checkSetterPreconditions();
        this.attributeValuesFunction = (Function)Constraint.isNotNull(function, (String)"Attribute Function cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.attributeValuesFunction == null) {
            throw new ComponentInitializationException("Attribute value lookup strategy cannot be null");
        }
    }

    @Nullable
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        List<IdPAttributeValue> results = this.attributeValuesFunction.apply((ProfileRequestContext)resolutionContext.getProfileRequestContextLookupStrategy().apply(resolutionContext));
        if (null == results) {
            this.log.debug("{} Generated no values", (Object)this.getLogPrefix());
            return null;
        }
        this.log.debug("{} Generated {} values", (Object)this.getLogPrefix(), (Object)results.size());
        this.log.trace("{} Values: {}", (Object)this.getLogPrefix(), results);
        IdPAttribute attribute = new IdPAttribute(this.ensureId());
        attribute.setValues(results);
        return attribute;
    }
}

