/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.xmlobject.impl;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.idp.saml.xmlobject.KeyAuthority;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.QNameSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

@ThreadSafe
public class KeyAuthorityUnmarshaller
extends AbstractXMLObjectUnmarshaller {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(KeyAuthorityUnmarshaller.class);

    protected void processAttribute(@Nonnull XMLObject xmlObject, @Nonnull Attr attribute) throws UnmarshallingException {
        KeyAuthority authority = (KeyAuthority)xmlObject;
        if (attribute.getLocalName().equals("VerifyDepth")) {
            authority.setVerifyDepth(Integer.valueOf(attribute.getValue()));
        } else {
            QName attribQName = QNameSupport.getNodeQName((Node)attribute);
            if (attribute.isId()) {
                authority.getUnknownAttributes().registerID(attribQName);
            }
            authority.getUnknownAttributes().put(attribQName, attribute.getValue());
        }
    }

    protected void processChildElement(@Nonnull XMLObject parentXMLObject, @Nonnull XMLObject childXMLObject) throws UnmarshallingException {
        KeyAuthority authority = (KeyAuthority)parentXMLObject;
        if (childXMLObject instanceof KeyInfo) {
            authority.getKeyInfos().add((KeyInfo)childXMLObject);
        } else {
            super.processChildElement(parentXMLObject, childXMLObject);
        }
    }
}

