/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.metadata.impl.MetadataProviderContainer;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.NonnullFunction;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.spring.service.AbstractServiceableComponent;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;

public class MetadataResolverServiceStrategy
extends AbstractIdentifiableInitializableComponent
implements NonnullFunction<ApplicationContext, AbstractServiceableComponent<MetadataResolver>> {
    @Nonnull
    public AbstractServiceableComponent<MetadataResolver> apply(@Nullable ApplicationContext appContext) {
        if (appContext == null) {
            throw new ServiceException("ApplicationContext was null");
        }
        Collection containers = appContext.getBeansOfType(MetadataProviderContainer.class).values();
        if (containers.isEmpty()) {
            throw new ServiceException("Reload did not produce any bean of type " + MetadataProviderContainer.class.getName());
        }
        if (1 == containers.size()) {
            AbstractServiceableComponent result = (AbstractServiceableComponent)containers.iterator().next();
            assert (result != null);
            return result;
        }
        for (MetadataProviderContainer resolver : containers) {
            try {
                resolver.initialize();
            }
            catch (ComponentInitializationException e) {
                throw new BeanCreationException("could not preinitialize due to metadata resolver " + resolver.getId(), (Throwable)e);
            }
        }
        ArrayList containerList = new ArrayList(containers.size());
        containerList.addAll(containers);
        Collections.sort(containerList);
        ChainingMetadataResolver chain = new ChainingMetadataResolver();
        try {
            chain.setResolvers((List)((NonnullSupplier)containerList.stream().map(MetadataProviderContainer::getEmbeddedResolver).collect(CollectionSupport.nonnullCollector(Collectors.toList()))).get());
            chain.setId("MultiFileResolverFor:" + containers.size() + ":Resources");
            chain.initialize();
            MetadataProviderContainer result = new MetadataProviderContainer();
            result.setEmbeddedResolver((MetadataResolver)chain);
            result.setApplicationContext(appContext);
            result.initialize();
            return result;
        }
        catch (ComponentInitializationException | ResolverException e) {
            throw new ServiceException("Chaining constructor create failed", (Exception)e);
        }
    }
}

