/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.config;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.config.AbstractMetadataDrivenConfigurationLookupStrategy;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;

public class BooleanConfigurationLookupStrategy
extends AbstractMetadataDrivenConfigurationLookupStrategy<Boolean> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(BooleanConfigurationLookupStrategy.class);

    @Override
    @Nullable
    protected Boolean doTranslate(@Nonnull IdPAttribute tag) {
        List<IdPAttributeValue> values = tag.getValues();
        if (values.size() != 1) {
            LOG.error("Tag '{}' contained multiple values, returning none", (Object)tag.getId());
            return null;
        }
        LOG.debug("Converting tag '{}' to Boolean property", (Object)tag.getId());
        IdPAttributeValue value = values.get(0);
        if (value instanceof StringAttributeValue) {
            return XSBooleanValue.valueOf((String)((StringAttributeValue)value).getValue()).getValue();
        }
        LOG.error("Tag '{}' contained non-string value, returning null");
        return null;
    }

    @Override
    @Nullable
    protected Boolean doTranslate(@Nonnull Attribute tag) {
        List values = tag.getAttributeValues();
        if (values.size() != 1) {
            LOG.error("Tag '{}' contained multiple values, returning none", (Object)tag.getName());
            return null;
        }
        LOG.debug("Converting tag '{}' to Boolean property", (Object)tag.getName());
        XMLObject value = (XMLObject)values.get(0);
        assert (value != null);
        return this.xmlObjectToBoolean(value);
    }

    @Nullable
    private Boolean xmlObjectToBoolean(@Nonnull XMLObject object) {
        XSAny val;
        if (object instanceof XSString) {
            XSString val2 = (XSString)object;
            String value = val2.getValue();
            if (value != null) {
                return XSBooleanValue.valueOf((String)value).getValue();
            }
            return null;
        }
        if (object instanceof XSBoolean) {
            XSBoolean val3 = (XSBoolean)object;
            XSBooleanValue value = val3.getValue();
            return value != null ? value.getValue() : null;
        }
        if (object instanceof XSInteger) {
            XSInteger val4 = (XSInteger)object;
            Integer value = val4.getValue();
            return value != null ? Boolean.valueOf(value != 0) : null;
        }
        if (object instanceof XSAny && (val = (XSAny)object).getUnknownAttributes().isEmpty() && val.getUnknownXMLObjects().isEmpty()) {
            String value = val.getTextContent();
            if (value != null) {
                return XSBooleanValue.valueOf((String)value).getValue();
            }
            return null;
        }
        LOG.error("Unsupported conversion to Boolean from XMLObject type ({})", (Object)object.getClass().getName());
        return null;
    }
}

