/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.config;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.config.AbstractMetadataDrivenConfigurationLookupStrategy;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class BeanConfigurationLookupStrategy<T>
extends AbstractMetadataDrivenConfigurationLookupStrategy<T>
implements ApplicationContextAware {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(BeanConfigurationLookupStrategy.class);
    @NonnullAfterInit
    private ApplicationContext applicationContext;
    @NonnullAfterInit
    private Class<T> propertyType;

    public BeanConfigurationLookupStrategy() {
        this.setEnableCaching(false);
    }

    public void setPropertyType(@Nonnull Class<T> type) {
        this.checkSetterPreconditions();
        this.propertyType = (Class)Constraint.isNotNull(type, (String)"Property type cannot be null");
    }

    public void setApplicationContext(@Nonnull ApplicationContext context) throws BeansException {
        this.checkSetterPreconditions();
        this.applicationContext = context;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.propertyType == null || this.applicationContext == null) {
            throw new ComponentInitializationException("Property type and Spring ApplicationContext cannot be null");
        }
    }

    @Override
    @Nullable
    protected T doTranslate(@Nonnull IdPAttribute tag) {
        List<IdPAttributeValue> values = tag.getValues();
        if (values.size() != 1) {
            LOG.error("Tag '{}' contained multiple values, returning none", (Object)tag.getId());
            return null;
        }
        LOG.debug("Converting tag '{}' to Bean property of tyoe '{}'", (Object)tag.getId(), (Object)this.propertyType.getSimpleName());
        IdPAttributeValue value = values.get(0);
        if (value instanceof StringAttributeValue) {
            StringAttributeValue strval = (StringAttributeValue)value;
            try {
                Class<T> pt = this.propertyType;
                assert (pt != null);
                return (T)this.applicationContext.getBean(strval.getValue(), pt);
            }
            catch (BeansException e) {
                LOG.error("Error locating appropriately typed bean named {}", (Object)strval.getValue(), (Object)e);
                return null;
            }
        }
        LOG.error("Tag '{}' contained non-string value, returning null");
        return null;
    }

    @Override
    @Nullable
    protected T doTranslate(@Nonnull Attribute tag) {
        List values = tag.getAttributeValues();
        if (values.size() != 1) {
            LOG.error("Tag '{}' contained multiple values, returning none", (Object)tag.getName());
            return null;
        }
        LOG.debug("Converting tag '{}' to Bean property of tyoe '{}'", (Object)tag.getName(), (Object)this.propertyType.getSimpleName());
        XMLObject value = (XMLObject)values.get(0);
        assert (value != null);
        return this.xmlObjectToBean(value);
    }

    @Nullable
    private T xmlObjectToBean(@Nonnull XMLObject object) {
        XSAny val;
        String value = null;
        if (object instanceof XSString) {
            XSString val2 = (XSString)object;
            value = val2.getValue();
        } else if (object instanceof XSAny && (val = (XSAny)object).getUnknownAttributes().isEmpty() && val.getUnknownXMLObjects().isEmpty()) {
            value = val.getTextContent();
        }
        if (value != null) {
            try {
                assert (this.propertyType != null);
                return (T)this.applicationContext.getBean(value, this.propertyType);
            }
            catch (BeansException e) {
                LOG.error("Error locating appropriately typed bean named {}", (Object)value, (Object)e);
                return null;
            }
        }
        LOG.error("Unsupported conversion to Spring bean from XMLObject type ({})", (Object)object.getClass().getName());
        return null;
    }
}

