/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.config;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.config.AbstractMetadataDrivenConfigurationLookupStrategy;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBase64Binary;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.slf4j.Logger;

public abstract class AbstractCollectionConfigurationLookupStrategy<T1, T2>
extends AbstractMetadataDrivenConfigurationLookupStrategy<T2> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCollectionConfigurationLookupStrategy.class);
    @NonnullAfterInit
    private Class<T1> propertyType;

    @NonnullAfterInit
    public Class<T1> getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(@Nonnull Class<T1> type) {
        this.checkSetterPreconditions();
        this.propertyType = (Class)Constraint.isNotNull(type, (String)"Property type cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.propertyType == null) {
            throw new ComponentInitializationException("Property type cannot be null");
        }
    }

    @Nonnull
    protected T1 createInstanceFromString(@Nonnull @NotEmpty String input) throws ReflectiveOperationException {
        if (this.propertyType.isAssignableFrom(input.getClass())) {
            return this.propertyType.cast(input);
        }
        return this.propertyType.getConstructor(String.class).newInstance(input);
    }

    @Nullable
    protected String xmlObjectToString(@Nonnull XMLObject object) {
        XSAny val;
        if (object instanceof XSString) {
            XSString val2 = (XSString)object;
            return val2.getValue();
        }
        if (object instanceof XSURI) {
            XSURI val3 = (XSURI)object;
            return val3.getURI();
        }
        if (object instanceof XSBoolean) {
            XSBoolean val4 = (XSBoolean)object;
            XSBooleanValue value = val4.getValue();
            return value != null ? (value.getValue().booleanValue() ? "1" : "0") : null;
        }
        if (object instanceof XSInteger) {
            XSInteger val5 = (XSInteger)object;
            Integer value = val5.getValue();
            return value != null ? value.toString() : null;
        }
        if (object instanceof XSDateTime) {
            XSDateTime val6 = (XSDateTime)object;
            Instant dt = val6.getValue();
            return dt != null ? Long.toString(dt.toEpochMilli()) : null;
        }
        if (object instanceof XSBase64Binary) {
            XSBase64Binary val7 = (XSBase64Binary)object;
            return val7.getValue();
        }
        if (object instanceof XSAny && (val = (XSAny)object).getUnknownAttributes().isEmpty() && val.getUnknownXMLObjects().isEmpty()) {
            return val.getTextContent();
        }
        LOG.debug("Unsupported conversion to String from XMLObject type ({})", (Object)object.getClass().getName());
        return null;
    }
}

