/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context.logic;

import java.security.Principal;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.logic.AbstractAuthenticationResultPredicate;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class PrincipalInResultPredicate
extends AbstractAuthenticationResultPredicate {
    @Nonnull
    private Set<Principal> principals = CollectionSupport.emptySet();

    public void setPrincipals(@Nullable Collection<Principal> prins) {
        this.principals = prins != null ? CollectionSupport.copyToSet(prins) : CollectionSupport.emptySet();
    }

    @Override
    protected boolean doMatch(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationResult result) {
        Set<Principal> contents = result.getSubject().getPrincipals();
        return this.principals.stream().anyMatch(p -> contents.contains(p));
    }
}

