/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.security.KeyException;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.impl.BasicKeystoreKeyStrategy;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class UnlockDataSealers
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String KEYSTORE_PASSWORD_PARAM_NAME = "keystorePassword";
    @Nonnull
    @NotEmpty
    public static final String KEY_PASSWORD_PARAM_NAME = "keyPassword";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(UnlockDataSealers.class);
    @Nonnull
    private Collection<BasicKeystoreKeyStrategy> keyStrategies = CollectionSupport.emptyList();

    public void setKeyStrategies(@Nullable Collection<BasicKeystoreKeyStrategy> strategies) {
        this.checkSetterPreconditions();
        this.keyStrategies = strategies != null ? CollectionSupport.copyToList(strategies) : CollectionSupport.emptyList();
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext) || this.keyStrategies.isEmpty()) {
            return false;
        }
        if (this.getHttpServletRequest() == null) {
            this.log.warn("{} No HttpServletRequest available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        HttpServletRequest request = (HttpServletRequest)Constraint.isNotNull((Object)this.getHttpServletRequest(), (String)"Could not locate servlet request");
        String[] keystorePasswords = request.getParameterValues(KEYSTORE_PASSWORD_PARAM_NAME);
        String[] keyPasswords = request.getParameterValues(KEY_PASSWORD_PARAM_NAME);
        if (keystorePasswords == null || keyPasswords == null || keystorePasswords.length != this.keyStrategies.size() || keyPasswords.length != this.keyStrategies.size()) {
            this.log.warn("{} Password parameter count does not match size of configured KeyStrategy inputs", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        int i = 0;
        for (BasicKeystoreKeyStrategy ks : this.keyStrategies) {
            if (keystorePasswords[i] == null || keyPasswords[i] == null) {
                this.log.warn("{} Empty password supplied at index {}", (Object)this.getLogPrefix(), (Object)i);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            ks.setKeystorePassword(keystorePasswords[i]);
            ks.setKeyPassword(keyPasswords[i]);
            try {
                ks.getDefaultKey();
            }
            catch (KeyException e) {
                this.log.warn("{} Failed to unlock key strategy in collection with index {}", (Object)this.getLogPrefix(), (Object)i);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            ++i;
        }
    }
}

