/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.security.factory;

import java.io.InputStream;
import java.security.KeyStore;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.core.io.Resource;

public class KeyStoreFactoryBean
implements FactoryBean<KeyStore> {
    @Nullable
    private Resource resource;
    @Nullable
    private String keyPass;
    @Nullable
    private String type;
    @Nullable
    private String provider;
    @Nullable
    private KeyStore keyStore;

    public void setResource(@Nonnull Resource res) {
        this.resource = (Resource)Constraint.isNotNull((Object)res, (String)"KeyStore resource cannot be null");
    }

    public void setPassword(@Nullable String password) {
        this.keyPass = password;
    }

    public void setProvider(@Nullable String prov) {
        this.provider = StringSupport.trimOrNull((String)prov);
    }

    public void setType(@Nullable String typ) {
        this.type = StringSupport.trimOrNull((String)typ);
    }

    public KeyStore getObject() throws Exception {
        if (this.keyStore == null) {
            Resource resource2 = this.resource;
            if (resource2 == null) {
                throw new FactoryBeanNotInitializedException("Resource property cannot be null");
            }
            KeyStore ks = this.provider != null && this.type != null ? KeyStore.getInstance(this.type, this.provider) : (this.type != null ? KeyStore.getInstance(this.type) : KeyStore.getInstance(KeyStore.getDefaultType()));
            try (InputStream is = resource2.getInputStream();){
                ks.load(is, this.keyPass != null ? this.keyPass.toCharArray() : null);
            }
            this.keyStore = ks;
        }
        return this.keyStore;
    }

    @Nonnull
    public Class<?> getObjectType() {
        return KeyStore.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

